/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.data.OptionT$PurePartiallyApplied$;
import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.package$all$;
import fs2.Stream;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers$;
import org.http4s.HttpRoutes$;
import org.http4s.HttpVersion;
import org.http4s.Platform$;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.headers.Range$SubRange$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.package$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Vault;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FileService$ {
    public static final FileService$ MODULE$ = new FileService$();
    private static final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.server.staticcontent.FileService");

    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Async<F> F2) {
        return this.apply(config, Files$.MODULE$.forAsync(F2), F2);
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Files<F> evidence$3, Async<F> F2) {
        LazyRef BadTraversal$module = new LazyRef();
        F readPath = Files$.MODULE$.apply(evidence$3).realPath(Path$.MODULE$.apply(config.systemPath()));
        Object inner = package$all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package$all$.MODULE$.catsSyntaxApplicativeError(readPath, F2), F2), F2).flatMap((Function1<Either, Object> & Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either2 = x0$1;
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                Path rootPath = (Path)right.value();
                return ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(TranslateUri$.MODULE$.apply(config.pathPrefix(), new Kleisli((Function1<Request, OptionT> & Serializable)request -> this.withPath$1(rootPath, (Request)request, F2, evidence$3, config, BadTraversal$module)), OptionT$.MODULE$.catsDataMonoidKForOptionT(F2))), F2);
            }
            if (either2 instanceof Left) {
                bl = true;
                left = (Left)either2;
                if (left.value() instanceof NoSuchFileException) {
                    return package$all$.MODULE$.toFunctorOps(((SyncIO)logger.error((Function0<String> & Serializable)() -> new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will return none.").toString())).to(F2), F2).as(HttpRoutes$.MODULE$.empty(F2));
                }
            }
            if (bl) {
                Throwable e = (Throwable)left.value();
                return package$all$.MODULE$.toFunctorOps(((SyncIO)logger.error(e, (Function0<String> & Serializable)() -> new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will fail with a 500.").toString())).to(F2), F2).as(HttpRoutes$.MODULE$.pure(Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), OptionT$.MODULE$.catsDataMonadErrorForOptionT(F2)));
            }
            throw new MatchError(either2);
        });
        return FlattenOps$.MODULE$.flatten$extension(package$all$.MODULE$.catsSyntaxFlatten(new Kleisli((Function1<Object, OptionT> & Serializable)x$4 -> OptionT$.MODULE$.liftF(inner, F2)), Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F2))), Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F2)));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$filesOnly(Path path, FileService.Config<F> config, Request<F> req, Files<F> evidence$4, MonadError<F, Throwable> F2) {
        return new OptionT(package$all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$4).getBasicFileAttributes(path), F2).flatMap((Function1<BasicFileAttributes, Object> & Serializable)attr -> {
            if (attr.isDirectory()) {
                return StaticFile$.MODULE$.fromPath(path.$div("index.html"), new Some(req), evidence$4, F2).value();
            }
            if (!attr.isRegularFile()) {
                return F2.pure(None$.MODULE$);
            }
            return new OptionT(MODULE$.getPartialContentFile(path, config, req, evidence$4, F2)).orElse((Function0<OptionT> & Serializable)() -> StaticFile$.MODULE$.fromPath(path, config.bufferSize(), new Some(req), StaticFile$.MODULE$.calculateETag(evidence$4, F2), evidence$4, F2).map((Function1<Response, Response> & Serializable)x$5 -> (Response)x$5.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), F2), F2).value();
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong(some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private <F> F getPartialContentFile(Path file, FileService.Config<F> config, Request<F> req, Files<F> evidence$5, MonadError<F, Throwable> F2) {
        return package$all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$5).getBasicFileAttributes(file), F2).flatMap((Function1<BasicFileAttributes, Object> & Serializable)attr -> {
            Option<NonEmptyList<Header.Raw>> option;
            Some some;
            Range range;
            Option<Object> option2 = Headers$.MODULE$.get$extension((List<Header.Raw>)req.headers(), Header$Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
            if (option2 instanceof Some && (range = (Range)(some = (Some)option2).value()) != null) {
                RangeUnit rangeUnit = range.unit();
                NonEmptyList<Range.SubRange> nonEmptyList = range.ranges();
                RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
                RangeUnit rangeUnit3 = rangeUnit;
                if (!(rangeUnit2 != null ? !((Object)rangeUnit2).equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                    Range.SubRange subRange = nonEmptyList.head();
                    Object object = nonEmptyList.tail();
                    if (subRange != null) {
                        long s2 = subRange.first();
                        Option<Object> e = subRange.second();
                        if (((Object)Nil$.MODULE$).equals(object)) {
                            if (MODULE$.validRange(s2, e, attr.size())) {
                                long size = attr.size();
                                long start = s2 >= 0L ? s2 : scala.math.package$.MODULE$.max(0L, size + s2);
                                long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong(e.getOrElse(() -> size - 1L)));
                                return StaticFile$.MODULE$.fromPath(file, start, end + 1L, config.bufferSize(), new Some(req), StaticFile$.MODULE$.calculateETag(evidence$5, F2), evidence$5, F2).map((Function1<Response, Response> & Serializable)resp -> {
                                    List<Header.Raw> hs = Headers$.MODULE$.put$extension(resp.headers(), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header$ToRaw$.MODULE$.modelledHeadersToRaw(Content$minusRange$.MODULE$.apply(Range$SubRange$.MODULE$.apply(start, end), new Some<Object>(BoxesRunTime.boxToLong(size))), Content$minusRange$.MODULE$.headerInstance())}));
                                    Status x$1 = Status$.MODULE$.PartialContent();
                                    List<Header.Raw> x$2 = hs;
                                    HttpVersion x$3 = resp.copy$default$2();
                                    Stream x$4 = resp.copy$default$4();
                                    Vault x$5 = resp.copy$default$5();
                                    return resp.copy(x$1, x$3, x$2, x$4, x$5);
                                }, F2).value();
                            }
                            return FileService$.nope$1(attr, F2);
                        }
                    }
                }
            }
            if ((option = Headers$.MODULE$.get$extension((List<Header.Raw>)req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Range"}))).ci(Nil$.MODULE$))) instanceof Some) {
                return FileService$.nope$1(attr, F2);
            }
            if (None$.MODULE$.equals(option)) {
                return F2.pure(None$.MODULE$);
            }
            throw new MatchError(option);
        });
    }

    private static final /* synthetic */ FileService$BadTraversal$1$ BadTraversal$lzycompute$1(LazyRef BadTraversal$module$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$module$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : BadTraversal$module$1.initialize(new FileService$BadTraversal$1$());
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$BadTraversal$2(LazyRef BadTraversal$module$1) {
        if (BadTraversal$module$1.initialized()) {
            return (FileService$BadTraversal$1$)BadTraversal$module$1.value();
        }
        return FileService$.BadTraversal$lzycompute$1(BadTraversal$module$1);
    }

    public static final /* synthetic */ Option $anonfun$apply$6(Path path$1, Path rootPath$1, boolean existsPath) {
        if (existsPath && path$1.startsWith(rootPath$1)) {
            return new Some<Path>(path$1.absolute().normalize());
        }
        return None$.MODULE$;
    }

    private final OptionT withPath$1(Path rootPath, Request request, Async F$1, Files evidence$3$1, FileService.Config config$1, LazyRef BadTraversal$module$1) {
        Object f;
        if (request.pathInfo().isEmpty()) {
            f = F$1.pure(rootPath);
        } else {
            Vector segments = (Vector)request.pathInfo().segments().map((Function1<Uri.Path.Segment, String> & Serializable)x$2 -> {
                boolean x$1 = true;
                Charset x$22 = x$2.decoded$default$1();
                Function1<Object, Object> x$3 = x$2.decoded$default$3();
                return x$2.decoded(x$22, true, x$3);
            });
            f = F$1.catchNonFatal((Function0<Path> & Serializable)() -> segments.foldLeft(rootPath, (Function2<Path, String, Path> & Serializable)(x0$1, x1$1) -> {
                String string;
                Tuple2<Path, String> tuple2 = new Tuple2<Path, String>((Path)x0$1, (String)x1$1);
                if (tuple2 != null && ("".equals(string = tuple2._2()) ? true : (".".equals(string) ? true : "..".equals(string)))) {
                    throw this.org$http4s$server$staticcontent$FileService$$BadTraversal$2(BadTraversal$module$1);
                }
                if (tuple2 != null) {
                    Path path = tuple2._1();
                    String segment = tuple2._2();
                    return path.resolve(segment);
                }
                throw new MatchError(tuple2);
            }), $less$colon$less$.MODULE$.refl());
        }
        Object resolvePath = f;
        Object matchingPath = package$all$.MODULE$.toFlatMapOps(resolvePath, F$1).flatMap((Function1<Path, Object> & Serializable)path -> package$all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$3$1).exists((Path)path, false), F$1).map((Function1<Object, Option> & Serializable)existsPath -> FileService$.$anonfun$apply$6(path, rootPath, BoxesRunTime.unboxToBoolean(existsPath))));
        return ApplicativeErrorOps$.MODULE$.recoverWith$extension(package$all$.MODULE$.catsSyntaxApplicativeError(new OptionT(matchingPath).flatMap((Function1<Path, OptionT> & Serializable)path -> config$1.fs2PathCollector().apply((Path)path, config$1, request), F$1).semiflatMap((Function1<Response, Object> & Serializable)x$3 -> config$1.cacheStrategy().cache(request.pathInfo(), x$3, F$1), F$1), OptionT$.MODULE$.catsDataMonadErrorForOptionT(F$1)), new Serializable(F$1, BadTraversal$module$1){
            private static final long serialVersionUID = 0L;
            private final Async F$1;
            private final LazyRef BadTraversal$module$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(A1)) {
                    return (B1)OptionT$PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), this.F$1);
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(throwable);
            }
            {
                this.F$1 = F$1;
                this.BadTraversal$module$1 = BadTraversal$module$1;
            }
        }, OptionT$.MODULE$.catsDataMonadErrorForOptionT(F$1));
    }

    private static final Object nope$1(BasicFileAttributes attr$1, MonadError F$3) {
        Status x$1 = Status$.MODULE$.RangeNotSatisfiable();
        List<Header.Raw> x$2 = Headers$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header$ToRaw$.MODULE$.modelledHeadersToRaw(Content$minusRange$.MODULE$.apply(Range$SubRange$.MODULE$.apply(0L, attr$1.size() - 1L), new Some<Object>(BoxesRunTime.boxToLong(attr$1.size()))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion x$3 = Response$.MODULE$.apply$default$2();
        Stream<Nothing$, Object> x$4 = Response$.MODULE$.apply$default$4();
        Vault x$5 = Response$.MODULE$.apply$default$5();
        return package$all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(new Some<Response<Nothing$>>(Response$.MODULE$.apply(x$1, x$3, x$2, x$4, x$5))), F$3), F$3).widen();
    }

    private FileService$() {
    }
}

