/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import cats.Show;
import cats.Show$;
import cats.kernel.Order;
import cats.package$;
import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class Cidr$
implements Serializable {
    public static final Cidr$ MODULE$ = new Cidr$();
    private static final Regex CidrPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^/]+)/(\\d+)"));

    public <A extends IpAddress> Cidr<A> apply(A address, int prefixBits) {
        int maxPrefixBits = BoxesRunTime.unboxToInt(address.fold((Function1<Ipv4Address, Object> & Serializable)x$9 -> BoxesRunTime.boxToInteger(Cidr$.$anonfun$apply$1(x$9)), (Function1<Ipv6Address, Object> & Serializable)x$10 -> BoxesRunTime.boxToInteger(Cidr$.$anonfun$apply$2(x$10))));
        int b = prefixBits < 0 ? 0 : (prefixBits > maxPrefixBits ? maxPrefixBits : prefixBits);
        return new Cidr<A>(address, b);
    }

    public <A extends IpAddress> Cidr<A> fromIpAndMask(A address, A mask) {
        return address.$div(mask.prefixBits());
    }

    public Option<Cidr<IpAddress>> fromString(String value2) {
        return this.fromStringGeneral(value2, (Function1<String, Option> & Serializable)value -> IpAddress$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv4Address>> fromString4(String value2) {
        return this.fromStringGeneral(value2, (Function1<String, Option> & Serializable)value -> Ipv4Address$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv6Address>> fromString6(String value2) {
        return this.fromStringGeneral(value2, (Function1<String, Option> & Serializable)value -> Ipv6Address$.MODULE$.fromString((String)value));
    }

    private Regex CidrPattern() {
        return CidrPattern;
    }

    private <A extends IpAddress> Option<Cidr<A>> fromStringGeneral(String value, Function1<String, Option<A>> parseAddress) {
        Option<List<String>> option;
        String string = value;
        if (string != null && !(option = this.CidrPattern().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(2) == 0) {
            String addrStr = (String)((LinearSeqOps)option.get()).apply(0);
            String prefixBitsStr = (String)((LinearSeqOps)option.get()).apply(1);
            return parseAddress.apply(addrStr).flatMap((Function1<IpAddress, Option> & Serializable)addr2 -> {
                int maxPrefixBits = BoxesRunTime.unboxToInt(addr2.fold((Function1<Ipv4Address, Object> & Serializable)x$11 -> BoxesRunTime.boxToInteger(Cidr$.$anonfun$fromStringGeneral$2(x$11)), (Function1<Ipv6Address, Object> & Serializable)x$12 -> BoxesRunTime.boxToInteger(Cidr$.$anonfun$fromStringGeneral$3(x$12))));
                return Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(prefixBitsStr))).toOption().withFilter(prefixBits -> prefixBits >= 0 && prefixBits <= maxPrefixBits).map((Function1<Object, Cidr> & Serializable)prefixBits -> Cidr$.MODULE$.apply(addr2, BoxesRunTime.unboxToInt(prefixBits)));
            });
        }
        return None$.MODULE$;
    }

    public <A extends IpAddress> Order<Cidr<A>> order() {
        return package$.MODULE$.Order().fromOrdering(this.ordering());
    }

    public <A extends IpAddress> Ordering<Cidr<A>> ordering() {
        return scala.package$.MODULE$.Ordering().by((Function1<Cidr, Tuple2> & Serializable)x2 -> new Tuple2(x2.address(), BoxesRunTime.boxToInteger(x2.prefixBits())), Ordering$.MODULE$.Tuple2(IpAddress$.MODULE$.ordering(), Ordering$Int$.MODULE$));
    }

    public <A extends IpAddress> Show<Cidr<A>> show() {
        return Show$.MODULE$.fromToString();
    }

    public <A extends IpAddress> Option<Tuple2<A, Object>> unapply(Cidr<A> c) {
        return new Some<Tuple2<A, Object>>(new Tuple2<A, Integer>(c.address(), BoxesRunTime.boxToInteger(c.prefixBits())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cidr$.class);
    }

    public static final /* synthetic */ int $anonfun$apply$1(Ipv4Address x$9) {
        return 32;
    }

    public static final /* synthetic */ int $anonfun$apply$2(Ipv6Address x$10) {
        return 128;
    }

    public static final /* synthetic */ int $anonfun$fromStringGeneral$2(Ipv4Address x$11) {
        return 32;
    }

    public static final /* synthetic */ int $anonfun$fromStringGeneral$3(Ipv6Address x$12) {
        return 128;
    }

    private Cidr$() {
    }
}

