/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.queries.intervals.ConjunctionIntervalIterator;
import org.apache.lucene.queries.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.queries.intervals.Disjunctions;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;

class BlockIntervalsSource
extends ConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> subSources) {
        if (subSources.size() == 1) {
            return subSources.get(0);
        }
        return Intervals.or(Disjunctions.pullUp(subSources, BlockIntervalsSource::new));
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s2 : sources) {
            if (s2 instanceof BlockIntervalsSource) {
                flattened.addAll(((BlockIntervalsSource)s2).subSources);
                continue;
            }
            flattened.add(s2);
        }
        return flattened;
    }

    private BlockIntervalsSource(List<IntervalsSource> sources) {
        super(BlockIntervalsSource.flatten(sources), true);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        return new BlockIntervalIterator(iterators);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singletonList(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BlockIntervalsSource)) {
            return false;
        }
        BlockIntervalsSource b = (BlockIntervalsSource)other;
        return Objects.equals(this.subSources, b.subSources);
    }

    @Override
    public String toString() {
        return "BLOCK(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class BlockIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;

        BlockIntervalIterator(List<IntervalIterator> subIterators) {
            super(subIterators);
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int gaps() {
            return 0;
        }

        @Override
        public int nextInterval() throws IOException {
            if (((IntervalIterator)this.subIterators.get(0)).nextInterval() == Integer.MAX_VALUE) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int i = 1;
            while (i < this.subIterators.size()) {
                while (((IntervalIterator)this.subIterators.get(i)).start() <= ((IntervalIterator)this.subIterators.get(i - 1)).end()) {
                    if (((IntervalIterator)this.subIterators.get(i)).nextInterval() != Integer.MAX_VALUE) continue;
                    this.end = Integer.MAX_VALUE;
                    this.start = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (((IntervalIterator)this.subIterators.get(i)).start() == ((IntervalIterator)this.subIterators.get(i - 1)).end() + 1) {
                    ++i;
                    continue;
                }
                if (((IntervalIterator)this.subIterators.get(0)).nextInterval() == Integer.MAX_VALUE) {
                    this.end = Integer.MAX_VALUE;
                    this.start = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                i = 1;
            }
            this.start = ((IntervalIterator)this.subIterators.get(0)).start();
            this.end = ((IntervalIterator)this.subIterators.get(this.subIterators.size() - 1)).end();
            return this.start;
        }

        @Override
        protected void reset() {
            this.end = -1;
            this.start = -1;
        }
    }
}

