/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.document.CompletionPostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.search.suggest.document.CompletionsTermsReader;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;

final class CompletionFieldsProducer
extends FieldsProducer {
    private FieldsProducer delegateFieldsProducer;
    private Map<String, CompletionsTermsReader> readers;
    private IndexInput dictIn;

    private CompletionFieldsProducer(FieldsProducer delegateFieldsProducer, Map<String, CompletionsTermsReader> readers) {
        this.delegateFieldsProducer = delegateFieldsProducer;
        this.readers = readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletionFieldsProducer(SegmentReadState state, CompletionPostingsFormat.FSTLoadMode fstLoadMode) throws IOException {
        String indexFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "cmp");
        this.delegateFieldsProducer = null;
        boolean success = false;
        try {
            try (ChecksumIndexInput index = state.directory.openChecksumInput(indexFile, state.context);){
                String dictFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "lkp");
                this.dictIn = state.directory.openInput(dictFile, state.context);
                CodecUtil.checkIndexHeader(this.dictIn, "completion", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(this.dictIn);
                CodecUtil.checkIndexHeader(index, "completion", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName(index.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numFields = index.readVInt();
                this.readers = new HashMap<String, CompletionsTermsReader>(numFields);
                for (int i = 0; i < numFields; ++i) {
                    int fieldNumber = index.readVInt();
                    long offset = index.readVLong();
                    long minWeight = index.readVLong();
                    long maxWeight = index.readVLong();
                    byte type = index.readByte();
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNumber);
                    this.readers.put(fieldInfo.name, new CompletionsTermsReader(this.dictIn, offset, minWeight, maxWeight, type, fstLoadMode));
                }
                CodecUtil.checkFooter(index);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.delegateFieldsProducer, this.dictIn);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.delegateFieldsProducer, this.dictIn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        boolean success = false;
        try {
            this.delegateFieldsProducer.close();
            IOUtils.close(this.dictIn);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.delegateFieldsProducer, this.dictIn);
            throw throwable;
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.delegateFieldsProducer.checkIntegrity();
    }

    @Override
    public FieldsProducer getMergeInstance() {
        return new CompletionFieldsProducer(this.delegateFieldsProducer, this.readers);
    }

    @Override
    public long ramBytesUsed() {
        long ramBytesUsed = this.delegateFieldsProducer.ramBytesUsed();
        for (CompletionsTermsReader reader : this.readers.values()) {
            ramBytesUsed += reader.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> accountableList = new ArrayList<Accountable>();
        for (Map.Entry<String, CompletionsTermsReader> readerEntry : this.readers.entrySet()) {
            accountableList.add(Accountables.namedAccountable(readerEntry.getKey(), readerEntry.getValue()));
        }
        return Collections.unmodifiableCollection(accountableList);
    }

    @Override
    public Iterator<String> iterator() {
        return this.readers.keySet().iterator();
    }

    @Override
    public Terms terms(String field2) throws IOException {
        Terms terms = this.delegateFieldsProducer.terms(field2);
        if (terms == null) {
            return null;
        }
        return new CompletionTerms(terms, this.readers.get(field2));
    }

    @Override
    public int size() {
        return this.readers.size();
    }
}

