/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import cats.effect.SyncIO;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.http4s.Platform$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.Uri$Authority$;
import org.http4s.Uri$Path$;
import org.http4s.Uri$RegName$;
import org.http4s.Uri$Scheme$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.Function0;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005=3Qa\u0002\u0005\u0002\u0002=AQA\u0006\u0001\u0005\u0002]AaA\u0007\u0001!\u0002\u0013Y\u0002\"\u0002\u0017\u0001\r\u0003i\u0003\"\u0002\u001c\u0001\t\u00039\u0004\"B#\u0001\r\u00031\u0005\"\u0002&\u0001\t\u0003Y%AB*feZ,'O\u0003\u0002\n\u0015\u000511/\u001a:wKJT!a\u0003\u0007\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u00033\u0001i\u0011\u0001C\u0001\u0007Y><w-\u001a:\u0011\u0005q!cBA\u000f\"\u001d\tqr$D\u0001\u000b\u0013\t\u0001#\"\u0001\u0005QY\u0006$hm\u001c:n\u0013\t\u00113%A\u0007m_\u001e<WM\u001d$bGR|'/\u001f\u0006\u0003A)I!!\n\u0014\u0003\u00151{wmZ3s)f\u0004X-\u0003\u0002(Q\tiAj\\4hKJ4\u0015m\u0019;pefT!!\u000b\u0016\u0002\u00111|w\rN2biNT!a\u000b\u0007\u0002\u0013QL\b/\u001a7fm\u0016d\u0017aB1eIJ,7o]\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0004]\u0016$(\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003-\tG\r\u001a:fgNL\u0005\u000fN:\u0016\u0003a\u00022!\u000f!C\u001b\u0005Q$BA\u001e=\u0003\u0011I\u0007\u000fN:\u000b\u0005ur\u0014aB2p[\u000e\f7\u000f\u001e\u0006\u0002\u007f\u0005\u00191m\\7\n\u0005\u0005S$!D*pG.,G/\u00113ee\u0016\u001c8\u000f\u0005\u0002:\u0007&\u0011AI\u000f\u0002\n\u0013B\fE\r\u001a:fgN\f\u0001\"[:TK\u000e,(/Z\u000b\u0002\u000fB\u0011\u0011\u0003S\u0005\u0003\u0013J\u0011qAQ8pY\u0016\fg.A\u0004cCN,WK]5\u0016\u00031\u0003\"AH'\n\u00059S!aA+sS\u0002")
public abstract class Server {
    private final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger(Server.class.getName());

    public abstract InetSocketAddress address();

    public SocketAddress<IpAddress> addressIp4s() {
        return SocketAddress$.MODULE$.fromInetSocketAddress(this.address());
    }

    public abstract boolean isSecure();

    public Uri baseUri() {
        Product product2;
        Some<Uri.Scheme> some = new Some<Uri.Scheme>(this.isSecure() ? Uri$Scheme$.MODULE$.https() : Uri$Scheme$.MODULE$.http());
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            product2 = new Uri.Ipv4Address(Ipv4Address$.MODULE$.fromInet4Address(inet4Address));
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            product2 = new Uri.Ipv6Address(Ipv6Address$.MODULE$.fromInet6Address(inet6Address));
        } else {
            ((SyncIO)this.logger.warn((Function0<String> & Serializable)() -> new StringBuilder(26).append("Unexpected address type ").append(inetAddress.getClass()).append(": ").append(inetAddress).toString())).unsafeRunSync();
            product2 = Uri$RegName$.MODULE$.apply(inetAddress.getHostAddress());
        }
        Ordered<Uri.Ipv4Address> x$1 = product2;
        Some<Object> x$2 = new Some<Object>(BoxesRunTime.boxToInteger(this.address().getPort()));
        Option<Uri.UserInfo> x$3 = Uri$Authority$.MODULE$.apply$default$1();
        return new Uri(some, new Some<Uri.Authority>(new Uri.Authority(x$3, (Uri.Host)((Object)x$1), (Option<Object>)x$2)), Uri$Path$.MODULE$.Root(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }
}

