/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.RadixSelector;
import org.apache.lucene.util.Selector;
import org.apache.lucene.util.Sorter;
import org.apache.lucene.util.bkd.HeapPointWriter;
import org.apache.lucene.util.bkd.OfflinePointReader;
import org.apache.lucene.util.bkd.OfflinePointWriter;
import org.apache.lucene.util.bkd.PointValue;
import org.apache.lucene.util.bkd.PointWriter;

public final class BKDRadixSelector {
    private static final int HISTOGRAM_SIZE = 256;
    private static final int MAX_SIZE_OFFLINE_BUFFER = 8192;
    private final long[] histogram;
    private final int bytesPerDim;
    private final int bytesSorted;
    private final int packedBytesLength;
    private final int packedBytesDocIDLength;
    private final int maxPointsSortInHeap;
    private final byte[] offlineBuffer;
    private final int[] partitionBucket;
    private final byte[] scratch;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    private final int numDataDims;
    private final int numIndexDims;

    public BKDRadixSelector(int numDataDims, int numIndexDims, int bytesPerDim, int maxPointsSortInHeap, Directory tempDir, String tempFileNamePrefix) {
        this.bytesPerDim = bytesPerDim;
        this.numDataDims = numDataDims;
        this.numIndexDims = numIndexDims;
        this.packedBytesLength = numDataDims * bytesPerDim;
        this.packedBytesDocIDLength = this.packedBytesLength + 4;
        this.bytesSorted = bytesPerDim + (numDataDims - numIndexDims) * bytesPerDim + 4;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        int numberOfPointsOffline = 8192 / this.packedBytesDocIDLength;
        this.offlineBuffer = new byte[numberOfPointsOffline * this.packedBytesDocIDLength];
        this.partitionBucket = new int[this.bytesSorted];
        this.histogram = new long[256];
        this.scratch = new byte[this.bytesSorted];
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    /*
     * Exception decompiling
     */
    public byte[] select(PathSlice points, PathSlice[] partitionSlices, long from, long to, long partitionPoint, int dim, int dimCommonPrefix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void checkArgs(long from2, long to, long partitionPoint) {
        if (partitionPoint < from2) {
            throw new IllegalArgumentException("partitionPoint must be >= from");
        }
        if (partitionPoint >= to) {
            throw new IllegalArgumentException("partitionPoint must be < to");
        }
    }

    private int findCommonPrefixAndHistogram(OfflinePointWriter points, long from2, long to, int dim, int dimCommonPrefix) throws IOException {
        int commonPrefixPosition = this.bytesSorted;
        int offset = dim * this.bytesPerDim;
        try (OfflinePointReader reader = points.getReader(from2, to - from2, this.offlineBuffer);){
            assert (commonPrefixPosition > dimCommonPrefix);
            reader.next();
            PointValue pointValue = reader.pointValue();
            BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
            System.arraycopy(packedValueDocID.bytes, packedValueDocID.offset + offset, this.scratch, 0, this.bytesPerDim);
            System.arraycopy(packedValueDocID.bytes, packedValueDocID.offset + this.numIndexDims * this.bytesPerDim, this.scratch, this.bytesPerDim, (this.numDataDims - this.numIndexDims) * this.bytesPerDim + 4);
            for (long i = from2 + 1L; i < to; ++i) {
                reader.next();
                pointValue = reader.pointValue();
                if (commonPrefixPosition == dimCommonPrefix) {
                    int n = this.getBucket(offset, commonPrefixPosition, pointValue);
                    this.histogram[n] = this.histogram[n] + 1L;
                    for (long j = i + 1L; j < to; ++j) {
                        reader.next();
                        pointValue = reader.pointValue();
                        int n2 = this.getBucket(offset, commonPrefixPosition, pointValue);
                        this.histogram[n2] = this.histogram[n2] + 1L;
                    }
                    break;
                }
                int startIndex = dimCommonPrefix > this.bytesPerDim ? this.bytesPerDim : dimCommonPrefix;
                int endIndex = commonPrefixPosition > this.bytesPerDim ? this.bytesPerDim : commonPrefixPosition;
                packedValueDocID = pointValue.packedValueDocIDBytes();
                int j = Arrays.mismatch(this.scratch, startIndex, endIndex, packedValueDocID.bytes, packedValueDocID.offset + offset + startIndex, packedValueDocID.offset + offset + endIndex);
                if (j == -1) {
                    int endTieBreak;
                    int startTieBreak;
                    int k;
                    if (commonPrefixPosition > this.bytesPerDim && (k = Arrays.mismatch(this.scratch, this.bytesPerDim, commonPrefixPosition, packedValueDocID.bytes, packedValueDocID.offset + (startTieBreak = this.numIndexDims * this.bytesPerDim), packedValueDocID.offset + (endTieBreak = startTieBreak + commonPrefixPosition - this.bytesPerDim))) != -1) {
                        commonPrefixPosition = this.bytesPerDim + k;
                        Arrays.fill(this.histogram, 0L);
                        this.histogram[this.scratch[commonPrefixPosition] & 0xFF] = i - from2;
                    }
                } else {
                    commonPrefixPosition = dimCommonPrefix + j;
                    Arrays.fill(this.histogram, 0L);
                    this.histogram[this.scratch[commonPrefixPosition] & 0xFF] = i - from2;
                }
                if (commonPrefixPosition == this.bytesSorted) continue;
                int n = this.getBucket(offset, commonPrefixPosition, pointValue);
                this.histogram[n] = this.histogram[n] + 1L;
            }
        }
        for (int i = 0; i < commonPrefixPosition; ++i) {
            this.partitionBucket[i] = this.scratch[i] & 0xFF;
        }
        return commonPrefixPosition;
    }

    private int getBucket(int offset, int commonPrefixPosition, PointValue pointValue) {
        int bucket;
        if (commonPrefixPosition < this.bytesPerDim) {
            BytesRef packedValue = pointValue.packedValue();
            bucket = packedValue.bytes[packedValue.offset + offset + commonPrefixPosition] & 0xFF;
        } else {
            BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
            bucket = packedValueDocID.bytes[packedValueDocID.offset + this.numIndexDims * this.bytesPerDim + commonPrefixPosition - this.bytesPerDim] & 0xFF;
        }
        return bucket;
    }

    private byte[] buildHistogramAndPartition(OfflinePointWriter points, PointWriter left, PointWriter right, long from2, long to, long partitionPoint, int iteration, int baseCommonPrefix, int dim) throws IOException {
        PointWriter deltaPoints;
        int i;
        int commonPrefix = this.findCommonPrefixAndHistogram(points, from2, to, dim, baseCommonPrefix);
        if (commonPrefix == this.bytesSorted) {
            this.offlinePartition(points, left, right, null, from2, to, dim, commonPrefix - 1, partitionPoint);
            return this.partitionPointFromCommonPrefix();
        }
        long leftCount = 0L;
        long rightCount = 0L;
        for (i = 0; i < 256; ++i) {
            long size = this.histogram[i];
            if (leftCount + size > partitionPoint - from2) {
                this.partitionBucket[commonPrefix] = i;
                break;
            }
            leftCount += size;
        }
        for (i = this.partitionBucket[commonPrefix] + 1; i < 256; ++i) {
            rightCount += this.histogram[i];
        }
        long delta = this.histogram[this.partitionBucket[commonPrefix]];
        assert (leftCount + rightCount + delta == to - from2) : leftCount + rightCount + delta + " / " + (to - from2);
        if (commonPrefix == this.bytesSorted - 1) {
            long tieBreakCount = partitionPoint - from2 - leftCount;
            this.offlinePartition(points, left, right, null, from2, to, dim, commonPrefix, tieBreakCount);
            return this.partitionPointFromCommonPrefix();
        }
        try (PointWriter tempDeltaPoints = this.getDeltaPointWriter(left, right, delta, iteration);){
            this.offlinePartition(points, left, right, tempDeltaPoints, from2, to, dim, commonPrefix, 0L);
            deltaPoints = tempDeltaPoints;
        }
        long newPartitionPoint = partitionPoint - from2 - leftCount;
        if (deltaPoints instanceof HeapPointWriter) {
            return this.heapPartition((HeapPointWriter)deltaPoints, left, right, dim, 0, (int)deltaPoints.count(), Math.toIntExact(newPartitionPoint), ++commonPrefix);
        }
        return this.buildHistogramAndPartition((OfflinePointWriter)deltaPoints, left, right, 0L, deltaPoints.count(), newPartitionPoint, ++iteration, ++commonPrefix, dim);
    }

    private void offlinePartition(OfflinePointWriter points, PointWriter left, PointWriter right, PointWriter deltaPoints, long from2, long to, int dim, int bytePosition, long numDocsTiebreak) throws IOException {
        assert (bytePosition == this.bytesSorted - 1 || deltaPoints != null);
        int offset = dim * this.bytesPerDim;
        long tiebreakCounter = 0L;
        try (OfflinePointReader reader = points.getReader(from2, to - from2, this.offlineBuffer);){
            while (reader.next()) {
                PointValue pointValue = reader.pointValue();
                int bucket = this.getBucket(offset, bytePosition, pointValue);
                if (bucket < this.partitionBucket[bytePosition]) {
                    left.append(pointValue);
                    continue;
                }
                if (bucket > this.partitionBucket[bytePosition]) {
                    right.append(pointValue);
                    continue;
                }
                if (bytePosition == this.bytesSorted - 1) {
                    if (tiebreakCounter < numDocsTiebreak) {
                        left.append(pointValue);
                        ++tiebreakCounter;
                        continue;
                    }
                    right.append(pointValue);
                    continue;
                }
                deltaPoints.append(pointValue);
            }
        }
        points.destroy();
    }

    private byte[] partitionPointFromCommonPrefix() {
        byte[] partition = new byte[this.bytesPerDim];
        for (int i = 0; i < this.bytesPerDim; ++i) {
            partition[i] = (byte)this.partitionBucket[i];
        }
        return partition;
    }

    private byte[] heapPartition(HeapPointWriter points, PointWriter left, PointWriter right, int dim, int from2, int to, int partitionPoint, int commonPrefix) throws IOException {
        byte[] partition = this.heapRadixSelect(points, dim, from2, to, partitionPoint, commonPrefix);
        for (int i = from2; i < to; ++i) {
            PointValue value = points.getPackedValueSlice(i);
            if (i < partitionPoint) {
                left.append(value);
                continue;
            }
            right.append(value);
        }
        return partition;
    }

    private byte[] heapRadixSelect(HeapPointWriter points, int dim, int from2, int to, int partitionPoint, int commonPrefixLength) {
        int dimOffset = dim * this.bytesPerDim + commonPrefixLength;
        int dimCmpBytes = this.bytesPerDim - commonPrefixLength;
        int dataOffset = this.numIndexDims * this.bytesPerDim - dimCmpBytes;
        new RadixSelector(this.bytesSorted - commonPrefixLength){

            @Override
            protected void swap(int i, int j) {
                points.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                assert (k >= 0) : "negative prefix " + k;
                if (k < dimCmpBytes) {
                    return points.block[i * BKDRadixSelector.this.packedBytesDocIDLength + dimOffset + k] & 0xFF;
                }
                return points.block[i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset + k] & 0xFF;
            }

            @Override
            protected Selector getFallbackSelector(int d) {
                final int skypedBytes = d + commonPrefixLength;
                final int dimStart = dim * BKDRadixSelector.this.bytesPerDim + skypedBytes;
                final int dimEnd = dim * BKDRadixSelector.this.bytesPerDim + BKDRadixSelector.this.bytesPerDim;
                final int dataOffset2 = BKDRadixSelector.this.numIndexDims * BKDRadixSelector.this.bytesPerDim;
                final int dataLength = (BKDRadixSelector.this.numDataDims - BKDRadixSelector.this.numIndexDims) * BKDRadixSelector.this.bytesPerDim + 4;
                return new IntroSelector(){

                    @Override
                    protected void swap(int i, int j) {
                        points.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim) {
                            System.arraycopy(points.block, i * BKDRadixSelector.this.packedBytesDocIDLength + dim * BKDRadixSelector.this.bytesPerDim, BKDRadixSelector.this.scratch, 0, BKDRadixSelector.this.bytesPerDim);
                        }
                        System.arraycopy(points.block, i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2, BKDRadixSelector.this.scratch, BKDRadixSelector.this.bytesPerDim, dataLength);
                    }

                    @Override
                    protected int compare(int i, int j) {
                        int jOffset;
                        int iOffset;
                        int cmp;
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim && (cmp = FutureArrays.compareUnsigned(points.block, (iOffset = i * BKDRadixSelector.this.packedBytesDocIDLength) + dimStart, iOffset + dimEnd, points.block, (jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength) + dimStart, jOffset + dimEnd)) != 0) {
                            return cmp;
                        }
                        iOffset = i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        return FutureArrays.compareUnsigned(points.block, iOffset, iOffset + dataLength, points.block, jOffset, jOffset + dataLength);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        int jOffset;
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim) {
                            jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength;
                            int cmp = FutureArrays.compareUnsigned(BKDRadixSelector.this.scratch, skypedBytes, BKDRadixSelector.this.bytesPerDim, points.block, jOffset + dimStart, jOffset + dimEnd);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        return FutureArrays.compareUnsigned(BKDRadixSelector.this.scratch, BKDRadixSelector.this.bytesPerDim, BKDRadixSelector.this.bytesPerDim + dataLength, points.block, jOffset, jOffset + dataLength);
                    }
                };
            }
        }.select(from2, to, partitionPoint);
        byte[] partition = new byte[this.bytesPerDim];
        PointValue pointValue = points.getPackedValueSlice(partitionPoint);
        BytesRef packedValue = pointValue.packedValue();
        System.arraycopy(packedValue.bytes, packedValue.offset + dim * this.bytesPerDim, partition, 0, this.bytesPerDim);
        return partition;
    }

    public void heapRadixSort(HeapPointWriter points, int from2, int to, int dim, int commonPrefixLength) {
        int dimOffset = dim * this.bytesPerDim + commonPrefixLength;
        int dimCmpBytes = this.bytesPerDim - commonPrefixLength;
        int dataOffset = this.numIndexDims * this.bytesPerDim - dimCmpBytes;
        new MSBRadixSorter(this.bytesSorted - commonPrefixLength){

            @Override
            protected int byteAt(int i, int k) {
                assert (k >= 0) : "negative prefix " + k;
                if (k < dimCmpBytes) {
                    return points.block[i * BKDRadixSelector.this.packedBytesDocIDLength + dimOffset + k] & 0xFF;
                }
                return points.block[i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset + k] & 0xFF;
            }

            @Override
            protected void swap(int i, int j) {
                points.swap(i, j);
            }

            @Override
            protected Sorter getFallbackSorter(int k) {
                final int skypedBytes = k + commonPrefixLength;
                final int dimStart = dim * BKDRadixSelector.this.bytesPerDim + skypedBytes;
                final int dimEnd = dim * BKDRadixSelector.this.bytesPerDim + BKDRadixSelector.this.bytesPerDim;
                final int dataOffset2 = BKDRadixSelector.this.numIndexDims * BKDRadixSelector.this.bytesPerDim;
                final int dataLength = (BKDRadixSelector.this.numDataDims - BKDRadixSelector.this.numIndexDims) * BKDRadixSelector.this.bytesPerDim + 4;
                return new IntroSorter(){

                    @Override
                    protected void swap(int i, int j) {
                        points.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim) {
                            System.arraycopy(points.block, i * BKDRadixSelector.this.packedBytesDocIDLength + dim * BKDRadixSelector.this.bytesPerDim, BKDRadixSelector.this.scratch, 0, BKDRadixSelector.this.bytesPerDim);
                        }
                        System.arraycopy(points.block, i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2, BKDRadixSelector.this.scratch, BKDRadixSelector.this.bytesPerDim, dataLength);
                    }

                    @Override
                    protected int compare(int i, int j) {
                        int jOffset;
                        int iOffset;
                        int cmp;
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim && (cmp = FutureArrays.compareUnsigned(points.block, (iOffset = i * BKDRadixSelector.this.packedBytesDocIDLength) + dimStart, iOffset + dimEnd, points.block, (jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength) + dimStart, jOffset + dimEnd)) != 0) {
                            return cmp;
                        }
                        iOffset = i * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        return FutureArrays.compareUnsigned(points.block, iOffset, iOffset + dataLength, points.block, jOffset, jOffset + dataLength);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        int jOffset;
                        if (skypedBytes < BKDRadixSelector.this.bytesPerDim) {
                            jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength;
                            int cmp = FutureArrays.compareUnsigned(BKDRadixSelector.this.scratch, skypedBytes, BKDRadixSelector.this.bytesPerDim, points.block, jOffset + dimStart, jOffset + dimEnd);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        jOffset = j * BKDRadixSelector.this.packedBytesDocIDLength + dataOffset2;
                        return FutureArrays.compareUnsigned(BKDRadixSelector.this.scratch, BKDRadixSelector.this.bytesPerDim, BKDRadixSelector.this.bytesPerDim + dataLength, points.block, jOffset, jOffset + dataLength);
                    }
                };
            }
        }.sort(from2, to);
    }

    private PointWriter getDeltaPointWriter(PointWriter left, PointWriter right, long delta, int iteration) throws IOException {
        if (delta <= (long)this.getMaxPointsSortInHeap(left, right)) {
            return new HeapPointWriter(Math.toIntExact(delta), this.packedBytesLength);
        }
        return new OfflinePointWriter(this.tempDir, this.tempFileNamePrefix, this.packedBytesLength, "delta" + iteration, delta);
    }

    private int getMaxPointsSortInHeap(PointWriter left, PointWriter right) {
        int pointsUsed = 0;
        if (left instanceof HeapPointWriter) {
            pointsUsed += ((HeapPointWriter)left).size;
        }
        if (right instanceof HeapPointWriter) {
            pointsUsed += ((HeapPointWriter)right).size;
        }
        assert (this.maxPointsSortInHeap >= pointsUsed);
        return this.maxPointsSortInHeap - pointsUsed;
    }

    PointWriter getPointWriter(long count, String desc) throws IOException {
        if (count <= (long)(this.maxPointsSortInHeap / 2)) {
            int size = Math.toIntExact(count);
            return new HeapPointWriter(size, this.packedBytesLength);
        }
        return new OfflinePointWriter(this.tempDir, this.tempFileNamePrefix, this.packedBytesLength, desc, count);
    }

    static /* synthetic */ int access$000(BKDRadixSelector x0) {
        return x0.packedBytesDocIDLength;
    }

    static /* synthetic */ int access$100(BKDRadixSelector x0) {
        return x0.bytesPerDim;
    }

    static /* synthetic */ int access$200(BKDRadixSelector x0) {
        return x0.numIndexDims;
    }

    static /* synthetic */ int access$300(BKDRadixSelector x0) {
        return x0.numDataDims;
    }

    static /* synthetic */ byte[] access$400(BKDRadixSelector x0) {
        return x0.scratch;
    }

    public static final class PathSlice {
        public final PointWriter writer;
        public final long start;
        public final long count;

        public PathSlice(PointWriter writer, long start, long count) {
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        public String toString() {
            return "PathSlice(start=" + this.start + " count=" + this.count + " writer=" + this.writer + ")";
        }
    }
}

