/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.codecs.idversion.VersionFieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.PairOutputs;

public final class VersionBlockTreeTermsReader
extends FieldsProducer {
    final IndexInput in;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, VersionFieldReader> fields = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionBlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        this.postingsReader = postingsReader;
        String termsFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tiv");
        this.in = state.directory.openInput(termsFile, state.context);
        boolean success = false;
        IndexInput indexIn = null;
        try {
            int termsVersion = CodecUtil.checkIndexHeader(this.in, "VersionBlockTreeTermsDict", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
            String indexFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tipv");
            indexIn = state.directory.openInput(indexFile, state.context);
            int indexVersion = CodecUtil.checkIndexHeader(indexIn, "VersionBlockTreeTermsIndex", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
            if (indexVersion != termsVersion) {
                throw new CorruptIndexException("mixmatched version files: " + this.in + "=" + termsVersion + "," + indexIn + "=" + indexVersion, indexIn);
            }
            CodecUtil.checksumEntireFile(indexIn);
            postingsReader.init(this.in, state);
            CodecUtil.retrieveChecksum(this.in);
            this.seekDir(this.in);
            this.seekDir(indexIn);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields, this.in);
            }
            for (int i = 0; i < numFields; ++i) {
                int field2 = this.in.readVInt();
                long numTerms = this.in.readVLong();
                assert (numTerms >= 0L);
                int numBytes = this.in.readVInt();
                BytesRef code = new BytesRef(new byte[numBytes]);
                this.in.readBytes(code.bytes, 0, numBytes);
                code.length = numBytes;
                long version = this.in.readVLong();
                PairOutputs.Pair<BytesRef, Long> rootCode = VersionBlockTreeTermsWriter.FST_OUTPUTS.newPair(code, version);
                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field2);
                assert (fieldInfo != null) : "field=" + field2;
                long sumTotalTermFreq = numTerms;
                long sumDocFreq = numTerms;
                assert (numTerms <= Integer.MAX_VALUE);
                int docCount = (int)numTerms;
                int longsSize = this.in.readVInt();
                BytesRef minTerm = VersionBlockTreeTermsReader.readBytesRef(this.in);
                BytesRef maxTerm = VersionBlockTreeTermsReader.readBytesRef(this.in);
                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), this.in);
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, this.in);
                }
                if (sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, this.in);
                }
                long indexStartFP = indexIn.readVLong();
                VersionFieldReader previous = this.fields.put(fieldInfo.name, new VersionFieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, this.in);
            }
            indexIn.close();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(indexIn, this);
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        BytesRef bytes = new BytesRef();
        bytes.length = in.readVInt();
        bytes.bytes = new byte[bytes.length];
        in.readBytes(bytes.bytes, 0, bytes.length);
        return bytes;
    }

    private void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.in, this.postingsReader);
        }
        finally {
            this.fields.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public Terms terms(String field2) throws IOException {
        assert (field2 != null);
        return this.fields.get(field2);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = this.postingsReader.ramBytesUsed();
        for (VersionFieldReader reader : this.fields.values()) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("field", this.fields));
        resources.add(Accountables.namedAccountable("delegate", this.postingsReader));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.in);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader.toString() + ")";
    }
}

