/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.BytesRef;

final class TermVectorsConsumerPerField
extends TermsHashPerField {
    private TermVectorsPostingsArray termVectorsPostingsArray;
    final TermVectorsConsumer termsWriter;
    boolean doVectors;
    boolean doVectorPositions;
    boolean doVectorOffsets;
    boolean doVectorPayloads;
    OffsetAttribute offsetAttribute;
    PayloadAttribute payloadAttribute;
    boolean hasPayloads;

    public TermVectorsConsumerPerField(FieldInvertState invertState, TermVectorsConsumer termsWriter, FieldInfo fieldInfo) {
        super(2, invertState, termsWriter, null, fieldInfo);
        this.termsWriter = termsWriter;
    }

    @Override
    void finish() {
        if (!this.doVectors || this.bytesHash.size() == 0) {
            return;
        }
        this.termsWriter.addFieldToFlush(this);
    }

    void finishDocument() throws IOException {
        if (!this.doVectors) {
            return;
        }
        this.doVectors = false;
        int numPostings = this.bytesHash.size();
        BytesRef flushTerm = this.termsWriter.flushTerm;
        assert (numPostings >= 0);
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        TermVectorsWriter tv = this.termsWriter.writer;
        int[] termIDs = this.sortPostings();
        tv.startField(this.fieldInfo, numPostings, this.doVectorPositions, this.doVectorOffsets, this.hasPayloads);
        ByteSliceReader posReader = this.doVectorPositions ? this.termsWriter.vectorSliceReaderPos : null;
        ByteSliceReader offReader = this.doVectorOffsets ? this.termsWriter.vectorSliceReaderOff : null;
        for (int j = 0; j < numPostings; ++j) {
            int termID = termIDs[j];
            int freq = postings.freqs[termID];
            this.termBytePool.setBytesRef(flushTerm, postings.textStarts[termID]);
            tv.startTerm(flushTerm, freq);
            if (this.doVectorPositions || this.doVectorOffsets) {
                if (posReader != null) {
                    this.initReader(posReader, termID, 0);
                }
                if (offReader != null) {
                    this.initReader(offReader, termID, 1);
                }
                tv.addProx(freq, posReader, offReader);
            }
            tv.finishTerm();
        }
        tv.finishField();
        this.reset();
        this.fieldInfo.setStoreTermVectors();
    }

    @Override
    boolean start(IndexableField field2, boolean first2) {
        super.start(field2, first2);
        assert (field2.fieldType().indexOptions() != IndexOptions.NONE);
        if (first2) {
            if (this.bytesHash.size() != 0) {
                this.reset();
            }
            this.bytesHash.reinit();
            this.hasPayloads = false;
            this.doVectors = field2.fieldType().storeTermVectors();
            if (this.doVectors) {
                this.termsWriter.hasVectors = true;
                this.doVectorPositions = field2.fieldType().storeTermVectorPositions();
                this.doVectorOffsets = field2.fieldType().storeTermVectorOffsets();
                if (this.doVectorPositions) {
                    this.doVectorPayloads = field2.fieldType().storeTermVectorPayloads();
                } else {
                    this.doVectorPayloads = false;
                    if (field2.fieldType().storeTermVectorPayloads()) {
                        throw new IllegalArgumentException("cannot index term vector payloads without term vector positions (field=\"" + field2.name() + "\")");
                    }
                }
            } else {
                if (field2.fieldType().storeTermVectorOffsets()) {
                    throw new IllegalArgumentException("cannot index term vector offsets when term vectors are not indexed (field=\"" + field2.name() + "\")");
                }
                if (field2.fieldType().storeTermVectorPositions()) {
                    throw new IllegalArgumentException("cannot index term vector positions when term vectors are not indexed (field=\"" + field2.name() + "\")");
                }
                if (field2.fieldType().storeTermVectorPayloads()) {
                    throw new IllegalArgumentException("cannot index term vector payloads when term vectors are not indexed (field=\"" + field2.name() + "\")");
                }
            }
        } else {
            if (this.doVectors != field2.fieldType().storeTermVectors()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectors changed for field=\"" + field2.name() + "\")");
            }
            if (this.doVectorPositions != field2.fieldType().storeTermVectorPositions()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPositions changed for field=\"" + field2.name() + "\")");
            }
            if (this.doVectorOffsets != field2.fieldType().storeTermVectorOffsets()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorOffsets changed for field=\"" + field2.name() + "\")");
            }
            if (this.doVectorPayloads != field2.fieldType().storeTermVectorPayloads()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPayloads changed for field=\"" + field2.name() + "\")");
            }
        }
        if (this.doVectors) {
            if (this.doVectorOffsets) {
                this.offsetAttribute = this.fieldState.offsetAttribute;
                assert (this.offsetAttribute != null);
            }
            this.payloadAttribute = this.doVectorPayloads ? this.fieldState.payloadAttribute : null;
        }
        return this.doVectors;
    }

    void writeProx(TermVectorsPostingsArray postings, int termID) {
        if (this.doVectorOffsets) {
            int startOffset = this.fieldState.offset + this.offsetAttribute.startOffset();
            int endOffset = this.fieldState.offset + this.offsetAttribute.endOffset();
            this.writeVInt(1, startOffset - postings.lastOffsets[termID]);
            this.writeVInt(1, endOffset - startOffset);
            postings.lastOffsets[termID] = endOffset;
        }
        if (this.doVectorPositions) {
            BytesRef payload = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
            int pos = this.fieldState.position - postings.lastPositions[termID];
            if (payload != null && payload.length > 0) {
                this.writeVInt(0, pos << 1 | 1);
                this.writeVInt(0, payload.length);
                this.writeBytes(0, payload.bytes, payload.offset, payload.length);
                this.hasPayloads = true;
            } else {
                this.writeVInt(0, pos << 1);
            }
            postings.lastPositions[termID] = this.fieldState.position;
        }
    }

    @Override
    void newTerm(int termID) {
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        postings.freqs[termID] = this.getTermFreq();
        postings.lastOffsets[termID] = 0;
        postings.lastPositions[termID] = 0;
        this.writeProx(postings, termID);
    }

    @Override
    void addTerm(int termID) {
        TermVectorsPostingsArray postings = this.termVectorsPostingsArray;
        int n = termID;
        postings.freqs[n] = postings.freqs[n] + this.getTermFreq();
        this.writeProx(postings, termID);
    }

    private int getTermFreq() {
        int freq = this.termFreqAtt.getTermFrequency();
        if (freq != 1) {
            if (this.doVectorPositions) {
                throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": cannot index term vector positions while using custom TermFrequencyAttribute");
            }
            if (this.doVectorOffsets) {
                throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": cannot index term vector offsets while using custom TermFrequencyAttribute");
            }
        }
        return freq;
    }

    @Override
    public void newPostingsArray() {
        this.termVectorsPostingsArray = (TermVectorsPostingsArray)this.postingsArray;
    }

    @Override
    ParallelPostingsArray createPostingsArray(int size) {
        return new TermVectorsPostingsArray(size);
    }

    static final class TermVectorsPostingsArray
    extends ParallelPostingsArray {
        int[] freqs;
        int[] lastOffsets;
        int[] lastPositions;

        public TermVectorsPostingsArray(int size) {
            super(size);
            this.freqs = new int[size];
            this.lastOffsets = new int[size];
            this.lastPositions = new int[size];
        }

        @Override
        ParallelPostingsArray newInstance(int size) {
            return new TermVectorsPostingsArray(size);
        }

        @Override
        void copyTo(ParallelPostingsArray toArray, int numToCopy) {
            assert (toArray instanceof TermVectorsPostingsArray);
            TermVectorsPostingsArray to = (TermVectorsPostingsArray)toArray;
            super.copyTo(toArray, numToCopy);
            System.arraycopy(this.freqs, 0, to.freqs, 0, this.size);
            System.arraycopy(this.lastOffsets, 0, to.lastOffsets, 0, this.size);
            System.arraycopy(this.lastPositions, 0, to.lastPositions, 0, this.size);
        }

        @Override
        int bytesPerPosting() {
            return super.bytesPerPosting() + 12;
        }
    }
}

