/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import java.sql.ResultSet;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import slick.ast.ColumnOption$AutoInc$;
import slick.ast.ColumnOption$PrimaryKey$;
import slick.ast.ColumnOption$Unique$;
import slick.ast.FieldSymbol;
import slick.ast.Node;
import slick.ast.ScalaBaseType;
import slick.ast.ScalaBaseType$;
import slick.ast.ScalaType;
import slick.compiler.CompilerState;
import slick.compiler.Phase$;
import slick.compiler.QueryCompiler;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcCapabilities$;
import slick.jdbc.JdbcModelBuilder;
import slick.jdbc.JdbcType;
import slick.jdbc.OptionResultConverter;
import slick.jdbc.OracleProfile;
import slick.jdbc.OracleProfile$ColumnOptions$class;
import slick.jdbc.SimpleJdbcAction;
import slick.jdbc.meta.MTable;
import slick.jdbc.meta.MTable$;
import slick.relational.RelationalCapabilities$;
import slick.relational.RelationalProfile;
import slick.relational.RelationalProfile$ColumnOption$Length$;
import slick.relational.RelationalSequenceComponent;
import slick.relational.RelationalTableComponent;
import slick.relational.RelationalTableComponent$ColumnOptions$class;
import slick.relational.ResultConverter;
import slick.sql.SqlProfile;
import slick.sql.SqlTableComponent;
import slick.sql.SqlTableComponent$ColumnOptions$class;

public abstract class OracleProfile$class {
    public static Set computeCapabilities(OracleProfile $this) {
        return (Set)$this.slick$jdbc$OracleProfile$$super$computeCapabilities().$minus((Object)RelationalCapabilities$.MODULE$.foreignKeyActions()).$minus((Object)JdbcCapabilities$.MODULE$.insertOrUpdate()).$minus((Object)JdbcCapabilities$.MODULE$.booleanMetaData()).$minus((Object)JdbcCapabilities$.MODULE$.distinguishesIntTypes()).$minus((Object)JdbcCapabilities$.MODULE$.supportsByte());
    }

    public static boolean useServerSideUpsert(OracleProfile $this) {
        return true;
    }

    public static boolean useServerSideUpsertReturning(OracleProfile $this) {
        return false;
    }

    public static JdbcModelBuilder createModelBuilder(OracleProfile $this, Seq tables, boolean ignoreInvalidDefaults, ExecutionContext ec) {
        return new OracleProfile.ModelBuilder($this, (Seq<MTable>)tables, ignoreInvalidDefaults, ec);
    }

    public static DBIOAction defaultTables(OracleProfile $this, ExecutionContext ec) {
        return new SimpleJdbcAction(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(JdbcBackend.JdbcActionContext x$2) {
                return x$2.session().metaData().getUserName();
            }
        }).flatMap(new Serializable($this, ec){
            public static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final DBIOAction<Vector<MTable>, NoStream, Effect.Read> apply(String user) {
                return MTable$.MODULE$.getTables((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)user), (Option<String>)None$.MODULE$, (Option<Seq<String>>)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLE"})))).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector<MTable> apply(Vector<MTable> mtables) {
                        return mtables;
                    }
                }, this.ec$1);
            }
            {
                this.ec$1 = ec$1;
            }
        }, ec);
    }

    public static QueryCompiler computeQueryCompiler(OracleProfile $this) {
        return $this.slick$jdbc$OracleProfile$$super$computeQueryCompiler().addAfter(Phase$.MODULE$.removeTakeDrop(), Phase$.MODULE$.expandSums()).replace(Phase$.MODULE$.resolveZipJoinsRownumStyle()).$minus(Phase$.MODULE$.fixRowNumberOrdering()).$plus(Phase$.MODULE$.rewriteBooleans()).$plus(new OracleProfile.RemoveSubqueryOrdering($this));
    }

    public static OracleProfile.QueryBuilder createQueryBuilder(OracleProfile $this, Node n, CompilerState state) {
        return new OracleProfile.QueryBuilder($this, n, state);
    }

    public static OracleProfile.TableDDLBuilder createTableDDLBuilder(OracleProfile $this, RelationalTableComponent.Table table) {
        return new OracleProfile.TableDDLBuilder($this, table);
    }

    public static OracleProfile.ColumnDDLBuilder createColumnDDLBuilder(OracleProfile $this, FieldSymbol column, RelationalTableComponent.Table table) {
        return new OracleProfile.ColumnDDLBuilder($this, column);
    }

    public static OracleProfile.SequenceDDLBuilder createSequenceDDLBuilder(OracleProfile $this, RelationalSequenceComponent.Sequence seq) {
        return new OracleProfile.SequenceDDLBuilder($this, seq);
    }

    public static String defaultSqlTypeName(OracleProfile $this, JdbcType tmd, Option sym) {
        String string;
        int n = tmd.sqlType();
        switch (n) {
            default: {
                string = $this.slick$jdbc$OracleProfile$$super$defaultSqlTypeName(tmd, sym);
                break;
            }
            case 6: {
                string = "BINARY_FLOAT";
                break;
            }
            case 8: {
                string = "BINARY_DOUBLE";
                break;
            }
            case -6: {
                string = "NUMBER(3)";
                break;
            }
            case 5: {
                string = "NUMBER(5)";
                break;
            }
            case -5: {
                string = "NUMBER(19)";
                break;
            }
            case 4: {
                string = "NUMBER(10)";
                break;
            }
            case 12: {
                Option size2 = sym.flatMap((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Option<RelationalProfile.ColumnOption.Length> apply(FieldSymbol x$3) {
                        return x$3.findColumnOption(ClassTag$.MODULE$.apply(RelationalProfile.ColumnOption.Length.class));
                    }
                });
                string = (String)size2.fold((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "VARCHAR2(254)";
                    }
                }, (Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(RelationalProfile.ColumnOption.Length l) {
                        return l.varying() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VARCHAR2(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)l.length())})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)l.length())}));
                    }
                });
            }
        }
        return string;
    }

    public static JdbcActionComponent.SchemaActionExtensionMethodsImpl createSchemaActionExtensionMethods(OracleProfile $this, SqlProfile.DDL schema2) {
        return new OracleProfile.SchemaActionExtensionMethodsImpl($this, schema2);
    }

    public static ResultConverter createOptionResultConverter(OracleProfile $this, JdbcType ti, int idx) {
        ScalaType scalaType = ti.scalaType();
        ScalaBaseType<String> scalaBaseType = ScalaBaseType$.MODULE$.stringType();
        return !(scalaType != null ? !scalaType.equals(scalaBaseType) : scalaBaseType != null) ? new OptionResultConverter<String>($this, ti, idx){

            public Option<String> read(ResultSet pr) {
                String v = (String)this.ti().getValue(pr, this.idx());
                return v == null || v.length() == 0 ? None$.MODULE$ : new Some((Object)v);
            }
        } : $this.slick$jdbc$OracleProfile$$super$createOptionResultConverter(ti, idx);
    }

    public static void $init$(OracleProfile $this) {
        $this.slick$jdbc$OracleProfile$_setter_$columnOptions_$eq(new OracleProfile.ColumnOptions($this){
            private final /* synthetic */ OracleProfile $outer;
            private final ColumnOption$PrimaryKey$ PrimaryKey;
            private final ColumnOption$AutoInc$ AutoInc;
            private final ColumnOption$Unique$ Unique;
            private final RelationalProfile$ColumnOption$Length$ Length;

            public OracleProfile.ColumnOption.AutoIncSequenceName AutoIncSequenceName(String name2) {
                return OracleProfile$ColumnOptions$class.AutoIncSequenceName(this, name2);
            }

            public OracleProfile.ColumnOption.AutoIncTriggerName AutoIncTriggerName(String name2) {
                return OracleProfile$ColumnOptions$class.AutoIncTriggerName(this, name2);
            }

            public SqlProfile.ColumnOption.SqlType SqlType(String typeName) {
                return SqlTableComponent$ColumnOptions$class.SqlType(this, typeName);
            }

            public ColumnOption$PrimaryKey$ PrimaryKey() {
                return this.PrimaryKey;
            }

            public ColumnOption$AutoInc$ AutoInc() {
                return this.AutoInc;
            }

            public ColumnOption$Unique$ Unique() {
                return this.Unique;
            }

            public RelationalProfile$ColumnOption$Length$ Length() {
                return this.Length;
            }

            public void slick$relational$RelationalTableComponent$ColumnOptions$_setter_$PrimaryKey_$eq(ColumnOption$PrimaryKey$ x$1) {
                this.PrimaryKey = x$1;
            }

            public void slick$relational$RelationalTableComponent$ColumnOptions$_setter_$AutoInc_$eq(ColumnOption$AutoInc$ x$1) {
                this.AutoInc = x$1;
            }

            public void slick$relational$RelationalTableComponent$ColumnOptions$_setter_$Unique_$eq(ColumnOption$Unique$ x$1) {
                this.Unique = x$1;
            }

            public void slick$relational$RelationalTableComponent$ColumnOptions$_setter_$Length_$eq(RelationalProfile$ColumnOption$Length$ x$1) {
                this.Length = x$1;
            }

            public <T> RelationalProfile.ColumnOption.Default<T> Default(T defaultValue) {
                return RelationalTableComponent$ColumnOptions$class.Default(this, defaultValue);
            }

            public /* synthetic */ OracleProfile slick$jdbc$OracleProfile$ColumnOptions$$$outer() {
                return this.$outer;
            }

            public /* synthetic */ SqlTableComponent slick$sql$SqlTableComponent$ColumnOptions$$$outer() {
                return this.$outer;
            }

            public /* synthetic */ RelationalTableComponent slick$relational$RelationalTableComponent$ColumnOptions$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                RelationalTableComponent$ColumnOptions$class.$init$(this);
                SqlTableComponent$ColumnOptions$class.$init$(this);
                OracleProfile$ColumnOptions$class.$init$(this);
            }
        });
        $this.slick$jdbc$OracleProfile$_setter_$columnTypes_$eq(new OracleProfile.JdbcTypes($this));
        $this.slick$jdbc$OracleProfile$_setter_$blobBufferSize_$eq(4096);
        $this.slick$jdbc$OracleProfile$_setter_$scalarFrom_$eq(new Some((Object)"sys.dual"));
    }
}

