/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.node.QueryActionMap;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.cache.ReadOnlyResultStore;
import org.spin.tools.Util;
import org.spin.tools.config.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ModuleVersionInfo")
@XmlRootElement
public final class ModuleVersionInfo {
    private static final Logger log = Logger.getLogger(ModuleVersionInfo.class);
    private final Map<String, String> mapModuleToVersion = Util.makeHashMap();
    private final String resultStoreClassName;

    private ModuleVersionInfo() {
        this.resultStoreClassName = null;
    }

    public ModuleVersionInfo(Class<?> clazz, ReadOnlyResultStore readOnlyResultStore, QueryActionMap queryActionMap) {
        Field[] fields;
        this.resultStoreClassName = readOnlyResultStore != null ? readOnlyResultStore.getClass().getSimpleName() : null;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<?> fieldClass = field.getType();
            String fieldClassName = fieldClass.getName();
            if (!fieldClassName.startsWith("org.spin")) continue;
            this.mapModuleToVersion.put(Version.getModule(fieldClass), Version.getVersion(fieldClass));
        }
        this.mapModuleToVersion.put(Version.getModule(clazz), Version.getVersion(clazz));
        ArrayList queryMapTypes = Util.makeArrayList();
        queryMapTypes.addAll(queryActionMap.getQueryTypes());
        for (String queryType : queryMapTypes) {
            try {
                Class<?> queryActionClass = queryActionMap.getQueryAction(queryType).getClass();
                this.mapModuleToVersion.put(Version.getModule(queryActionClass), Version.getVersion(queryActionClass));
            }
            catch (UnknownQueryTypeException e) {
                log.warn((Object)("Initializing versionInfo, unknown query type '" + e.getMessage() + "': is another thread modifying the QueryMap?"));
            }
        }
    }

    public final Map<String, String> getModuleNameToVersion() {
        return Util.makeHashMap(this.mapModuleToVersion);
    }

    public final String getResultStoreClassName() {
        return this.resultStoreClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultStoreClassName == null ? 0 : this.resultStoreClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleVersionInfo other = (ModuleVersionInfo)obj;
        return !(this.resultStoreClassName == null ? other.resultStoreClassName != null : !this.resultStoreClassName.equals(other.resultStoreClassName));
    }
}

