/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import java.util.EnumSet;

public enum StatusCode {
    BroadcastStarted(false),
    QueryStarted(false),
    MalformedHeader,
    QueryDoesNotConformToSchema,
    ServiceNotSupported,
    NodeUnavailable,
    UnknownPeergroup,
    RoutingLoop,
    UnsupportedQueryType,
    UntrustedIdentService,
    QueryFailure,
    UntrustedQuerier;

    private final boolean error;

    private StatusCode() {
        this(true);
    }

    private StatusCode(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }

    public static final EnumSet<StatusCode> errors() {
        EnumSet<StatusCode> result = EnumSet.noneOf(StatusCode.class);
        for (StatusCode statusCode : StatusCode.values()) {
            if (!statusCode.error) continue;
            result.add(statusCode);
        }
        return result;
    }

    public static final EnumSet<StatusCode> nonErrors() {
        return EnumSet.complementOf(StatusCode.errors());
    }
}

