/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.filter;

import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;
import org.spin.tools.filter.DefaultDirectoryFilter;
import org.spin.tools.filter.DefaultFileFilter;

public final class FileFilterTool {
    private static final Logger log = Logger.getLogger(FileFilterTool.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();

    private FileFilterTool() {
    }

    public static File[] recursiveFilter(File inputPath) {
        return FileFilterTool.recursiveFilter(inputPath, new DefaultFileFilter(), new DefaultDirectoryFilter());
    }

    public static File[] recursiveFilter(File inputPath, FileFilter filter) {
        return FileFilterTool.recursiveFilter(inputPath, filter, new DefaultDirectoryFilter());
    }

    public static File[] recursiveFilter(File inputPath, FileFilter inputFileFilter, FileFilter directoryFileFilter) {
        if (INFO) {
            log.info((Object)("Fetching input files in path:" + inputPath.getAbsolutePath()));
        }
        File[] allInputFiles = new File[]{};
        if (inputPath.isDirectory()) {
            File[] inputFiles = inputPath.listFiles(inputFileFilter);
            if (DEBUG) {
                log.debug((Object)(inputFiles.length + " input files found"));
            }
            allInputFiles = new File[inputFiles.length];
            System.arraycopy(inputFiles, 0, allInputFiles, 0, inputFiles.length);
            File[] subDirs = inputPath.listFiles(directoryFileFilter);
            for (int i = 0; i < subDirs.length; ++i) {
                File subDir = subDirs[i];
                if (DEBUG) {
                    log.debug((Object)("Recursing into subdirectory:" + subDir.getAbsolutePath()));
                }
                File[] tempsave = allInputFiles;
                File[] recursion = FileFilterTool.recursiveFilter(subDir, inputFileFilter, directoryFileFilter);
                allInputFiles = new File[tempsave.length + recursion.length];
                System.arraycopy(tempsave, 0, allInputFiles, 0, tempsave.length);
                System.arraycopy(recursion, 0, allInputFiles, tempsave.length, recursion.length);
            }
        }
        if (inputPath.isFile()) {
            allInputFiles = new File[]{inputPath};
        }
        if (INFO) {
            log.info((Object)("Fetched " + allInputFiles.length + " input files"));
        }
        return allInputFiles;
    }
}

