/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Interval")
@XmlRootElement(name="Interval")
public final class Interval {
    public static final Interval OneSecond = new Interval(1L, TimeUnit.SECONDS);
    public static final Interval FiveSeconds = new Interval(5L, TimeUnit.SECONDS);
    public static final Interval OneMinute = new Interval(60000L, TimeUnit.MILLISECONDS);
    public static final Interval FiveMinutes = new Interval(300000L, TimeUnit.MILLISECONDS);
    public static final Interval OneHour = new Interval(3600000L, TimeUnit.MILLISECONDS);
    public final long duration;
    public final TimeUnit unit;

    public static Interval of(long duration, TimeUnit unit) {
        return new Interval(duration, unit);
    }

    public static Interval milliseconds(long duration) {
        return new Interval(duration, TimeUnit.MILLISECONDS);
    }

    public static Interval seconds(long duration) {
        return new Interval(duration, TimeUnit.SECONDS);
    }

    private Interval() {
        this.duration = 0L;
        this.unit = null;
    }

    private Interval(long duration, TimeUnit unit) {
        Util.guardNotNull((Object)unit);
        this.duration = duration;
        this.unit = unit;
    }

    public String toString() {
        return this.duration + " " + this.unit.toString().toLowerCase();
    }

    public Interval normalized() {
        if (this.unit == TimeUnit.MILLISECONDS) {
            return this;
        }
        return new Interval(this.unit.toMillis(this.duration), TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.duration != other.duration) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit));
    }
}

