/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.spin.tools.ClassTools;
import org.spin.tools.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JAXBUtils {
    private static final Logger log = Logger.getLogger(JAXBUtils.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final Map<String, JAXBContext> packageNameContextCache = Util.makeHashMap();
    private static final Map<String, Marshaller> packageNameMarshallerCache = Util.makeHashMap();
    private static final Map<String, Unmarshaller> packageNameUnmarshallerCache = Util.makeHashMap();
    private static final Map<String, CacheEntry> contextCache = Util.makeHashMap();
    private static final Map<JAXBContext, Marshaller> marshallerCache = Util.makeHashMap();
    private static final Map<JAXBContext, Unmarshaller> unmarshallerCache = Util.makeHashMap();

    private JAXBUtils() {
    }

    public static final <T> T unmarshal(Node node, Class<T> clazz) throws JAXBException {
        return JAXBUtils.unmarshal(node, clazz, false);
    }

    public static final <T> T unmarshalAndValidate(Node node, Class<T> clazz) throws JAXBException {
        return JAXBUtils.unmarshal(node, clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T unmarshal(Node node, Class<T> clazz, boolean validate) throws JAXBException {
        Unmarshaller unmarshaller;
        if (DEBUG) {
            if (node.getClass().isAssignableFrom(Element.class)) {
                log.debug((Object)("Unmarshalling '" + JAXBUtils.marshalToString((Element)node) + "' into '" + clazz.getSimpleName() + "'"));
            }
            log.debug((Object)("Unmarshalling '" + node + "' into '" + clazz.getSimpleName() + "'"));
        }
        Unmarshaller unmarshaller2 = unmarshaller = validate ? JAXBUtils.getUncachedUnmarshaller(clazz) : JAXBUtils.getUnmarshaller(clazz);
        if (validate) {
            if (DEBUG) {
                log.debug((Object)"Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromClass(clazz));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return (T)unmarshaller.unmarshal(node, clazz).getValue();
        }
    }

    public static final Object unmarshalAndValidate(Node node, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal(node, packageNames, true);
    }

    public static final Object unmarshal(Node node, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal(node, packageNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshal(Node node, String packageNames, boolean validate) throws JAXBException {
        Unmarshaller unmarshaller;
        Unmarshaller unmarshaller2 = unmarshaller = validate ? JAXBUtils.getUncachedUnmarshaller(packageNames) : JAXBUtils.getUnmarshaller(packageNames);
        if (validate) {
            if (DEBUG) {
                log.debug((Object)"Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromPackage(packageNames));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return unmarshaller.unmarshal(node);
        }
    }

    private static final Schema getSchemaFromClass(Class<?> clazz) throws JAXBException {
        return JAXBUtils.getSchemaFromContext(JAXBUtils.getContext(clazz));
    }

    private static final Schema getSchemaFromPackage(String packageNames) throws JAXBException {
        return JAXBUtils.getSchemaFromContext(JAXBUtils.getContext(packageNames));
    }

    private static final Schema getSchemaFromContext(JAXBContext context) throws JAXBException {
        ByteArraySchemaOutputResolver schemaOutputResolver = new ByteArraySchemaOutputResolver();
        try {
            context.generateSchema((SchemaOutputResolver)schemaOutputResolver);
        }
        catch (IOException e) {
            throw new JAXBException("Error generating schema from context: " + context, (Throwable)e);
        }
        List<ByteArrayOutputStream> outs = schemaOutputResolver.getOutputs();
        Source[] sources = new StreamSource[outs.size()];
        for (int i : Util.range(outs.size())) {
            ByteArrayOutputStream out = outs.get(i);
            sources[i] = new StreamSource(new ByteArrayInputStream(out.toByteArray()), "");
        }
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
        }
        catch (SAXException e) {
            throw new JAXBException("SAX parsing error occurred while generating schema from class.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T unmarshal(Reader reader, Class<T> clazz, boolean validate) throws JAXBException {
        Unmarshaller unmarshaller;
        if (DEBUG) {
            log.debug((Object)("Unmarshalling from Reader into '" + clazz.getSimpleName() + "'"));
        }
        Unmarshaller unmarshaller2 = unmarshaller = validate ? JAXBUtils.getUncachedUnmarshaller(clazz) : JAXBUtils.getUnmarshaller(clazz);
        if (validate) {
            if (DEBUG) {
                log.debug((Object)"Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromClass(clazz));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return (T)unmarshaller.unmarshal((Source)new StreamSource(reader), clazz).getValue();
        }
    }

    public static final <T> T unmarshalAndValidate(Reader reader, Class<T> clazz) throws JAXBException {
        return JAXBUtils.unmarshal(reader, clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshal(Reader reader, String packageNames, boolean validate) throws JAXBException {
        Unmarshaller unmarshaller;
        Unmarshaller unmarshaller2 = unmarshaller = validate ? JAXBUtils.getUncachedUnmarshaller(packageNames) : JAXBUtils.getUnmarshaller(packageNames);
        if (validate) {
            unmarshaller.setSchema(JAXBUtils.getSchemaFromPackage(packageNames));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return unmarshaller.unmarshal(reader);
        }
    }

    public static final Object unmarshalAndValidate(Reader reader, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal(reader, packageNames, true);
    }

    public static final <T> T unmarshal(Reader reader, Class<T> clazz) throws JAXBException {
        return JAXBUtils.unmarshal(reader, clazz, false);
    }

    public static final Object unmarshal(Reader reader, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal(reader, packageNames, false);
    }

    public static final <T> T unmarshalAndValidate(File file, Class<T> clazz) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), clazz, true);
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public static final Object unmarshalAndValidate(File file, String packageNames) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), packageNames, true);
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public static final <T> T unmarshal(File file, Class<T> clazz) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), clazz, false);
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public static final Object unmarshal(File file, String packageNames) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), packageNames, false);
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public static final <T> T unmarshalAndValidate(String xml, Class<T> clazz) throws JAXBException {
        if (DEBUG) {
            log.debug((Object)("Unmarshalling from XML into '" + clazz.getSimpleName() + "'"));
        }
        return JAXBUtils.unmarshal((Reader)new StringReader(xml), clazz, true);
    }

    public static final <T> T unmarshal(String xml, Class<T> clazz) throws JAXBException {
        if (DEBUG) {
            log.debug((Object)("Unmarshalling from XML into '" + clazz.getSimpleName() + "'"));
        }
        return JAXBUtils.unmarshal((Reader)new StringReader(xml), clazz, false);
    }

    public static final Object unmarshal(String xml, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal((Reader)new StringReader(xml), packageNames, false);
    }

    public static final Object unmarshalAndValidate(String xml, String packageNames) throws JAXBException {
        return JAXBUtils.unmarshal((Reader)new StringReader(xml), packageNames, true);
    }

    public static final String marshalToString(Object object) throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBUtils.marshalToWriter(object, writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void marshalToWriter(Object object, Writer writer) throws JAXBException {
        Marshaller marshaller = JAXBUtils.getMarshaller(object.getClass());
        try {
            Marshaller marshaller2 = marshaller;
            synchronized (marshaller2) {
                marshaller.marshal(object, writer);
            }
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new JAXBException("Error flushing Writer: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String marshalToString(Element element) throws JAXBException {
        if (element == null) {
            return null;
        }
        try {
            Transformer nullTransformer;
            TransformerFactory transformerFactory = TransformerFactoryHolder.transformerFactory;
            synchronized (transformerFactory) {
                nullTransformer = TransformerFactoryHolder.transformerFactory.newTransformer();
            }
            StringWriter writer = new StringWriter();
            nullTransformer.transform(new DOMSource(element), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error marshalling DOM tree to String", (Throwable)e);
            return null;
        }
    }

    public static final void marshalToFile(Object object, File file) throws JAXBException {
        FileWriter writer = null;
        try {
            if (INFO) {
                log.info((Object)("Marshalling to '" + file.getAbsolutePath() + "'"));
            }
            writer = new FileWriter(file);
            JAXBUtils.marshalToWriter(object, writer);
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing file '" + file + "'"));
                }
            }
        }
    }

    public static final Element marshalToElement(Object object) throws JAXBException {
        return JAXBUtils.marshalToElement(object, null, null);
    }

    public static final Element marshalToElement(Object object, String packageName) throws JAXBException {
        return JAXBUtils.marshalToElement(object, null, packageName);
    }

    public static final Element marshalToElement(Object object, Marshaller marshaller) throws JAXBException {
        return JAXBUtils.marshalToElement(object, marshaller, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element marshalToElement(Object object, Marshaller marshaller, String packageName) throws JAXBException {
        Document doc;
        try {
            doc = LazyDocumentBuilder.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new JAXBException((Throwable)e);
        }
        Marshaller marshallerToUse = marshaller != null ? marshaller : (packageName == null ? JAXBUtils.getMarshaller(object.getClass()) : JAXBUtils.getMarshaller(packageName));
        Marshaller marshaller2 = marshallerToUse;
        synchronized (marshaller2) {
            marshallerToUse.marshal(object, (Node)doc);
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        Map<String, Unmarshaller> map = packageNameUnmarshallerCache;
        synchronized (map) {
            if (!packageNameUnmarshallerCache.containsKey(packageName)) {
                packageNameUnmarshallerCache.put(packageName, JAXBContext.newInstance((String)packageName).createUnmarshaller());
            }
        }
        return packageNameUnmarshallerCache.get(packageName);
    }

    public static final Unmarshaller getUncachedUnmarshaller(String packageName) throws JAXBException {
        return JAXBUtils.getContext(packageName).createUnmarshaller();
    }

    private static final Marshaller setMarshallerProperties(Marshaller marshaller) throws JAXBException {
        if (marshaller != null) {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Marshaller getMarshaller(String packageName) throws JAXBException {
        Map<String, Marshaller> map = packageNameMarshallerCache;
        synchronized (map) {
            if (!packageNameMarshallerCache.containsKey(packageName)) {
                packageNameMarshallerCache.put(packageName, JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(packageName).createMarshaller()));
            }
        }
        return packageNameMarshallerCache.get(packageName);
    }

    public static final Marshaller getUncachedMarshaller(String packageName) throws JAXBException {
        return JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(packageName).createMarshaller());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JAXBContext getContext(String packageName) throws JAXBException {
        Map<String, JAXBContext> map = packageNameContextCache;
        synchronized (map) {
            if (!packageNameContextCache.containsKey(packageName)) {
                packageNameContextCache.put(packageName, JAXBContext.newInstance((String)packageName));
            }
        }
        return packageNameContextCache.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Unmarshaller getUnmarshaller(Class<?> ... classes) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(classes);
        Map<JAXBContext, Unmarshaller> map = unmarshallerCache;
        synchronized (map) {
            if (!unmarshallerCache.containsKey(context)) {
                unmarshallerCache.put(context, context.createUnmarshaller());
            }
            return unmarshallerCache.get(context);
        }
    }

    public static final Unmarshaller getUncachedUnmarshaller(Class<?> ... classes) throws JAXBException {
        return JAXBUtils.getContext(classes).createUnmarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Marshaller getMarshaller(Class<?> ... classes) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(classes);
        Map<JAXBContext, Marshaller> map = marshallerCache;
        synchronized (map) {
            if (!marshallerCache.containsKey(context)) {
                marshallerCache.put(context, JAXBUtils.setMarshallerProperties(context.createMarshaller()));
            }
        }
        return marshallerCache.get(context);
    }

    public static final Marshaller getUncachedMarshaller(Class<?> ... classes) throws JAXBException {
        return JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(classes).createMarshaller());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JAXBContext getContext(Class<?> ... classes) throws JAXBException {
        if (classes == null || classes.length < 1) {
            throw new JAXBException("Null or empty list of classes passed in.");
        }
        if (!ClassTools.allSamePackage(classes)) {
            throw new JAXBException("Passed-in classes have different packages.");
        }
        String packageName = classes[0].getPackage().getName();
        Set<Class<?>> classSet = Util.asSet(classes);
        Map<String, CacheEntry> map = contextCache;
        synchronized (map) {
            if (!contextCache.containsKey(packageName)) {
                CacheEntry cacheEntry = new CacheEntry();
                cacheEntry.classSet = classSet;
                cacheEntry.context = JAXBContext.newInstance((Class[])classes);
                contextCache.put(packageName, cacheEntry);
            } else if (!contextCache.get(packageName).classSet.containsAll(classSet)) {
                CacheEntry cacheEntry = contextCache.get(packageName);
                JAXBUtils.invalidateMarshallerAndUnmarshallerCaches(cacheEntry.context);
                cacheEntry.classSet.addAll(classSet);
                cacheEntry.context = JAXBUtils.makeJAXBContext(cacheEntry.classSet);
            }
            return contextCache.get(packageName).context;
        }
    }

    private static final JAXBContext makeJAXBContext(Set<Class<?>> classSet) throws JAXBException {
        return JAXBContext.newInstance((Class[])classSet.toArray(new Class[classSet.size()]));
    }

    private static final synchronized void invalidateMarshallerAndUnmarshallerCaches(JAXBContext context) {
        marshallerCache.remove(context);
        unmarshallerCache.remove(context);
    }

    public static final Marshaller synchronizedMarshaller(Marshaller marshaller) {
        return new SynchronizedMarshaller(marshaller);
    }

    public static final Unmarshaller synchronizedUnmarshaller(Unmarshaller unmarshaller) {
        return new SynchronizedUnmarshaller(unmarshaller);
    }

    private static final class ByteArraySchemaOutputResolver
    extends SchemaOutputResolver {
        private final List<ByteArrayOutputStream> outs = Util.makeArrayList();

        public Result createOutput(String namespaceUri, String suggestedFileName) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.outs.add(out);
            StreamResult streamResult = new StreamResult(out);
            streamResult.setSystemId("");
            return streamResult;
        }

        public final void printSchemaToConsole() {
            for (ByteArrayOutputStream out : this.outs) {
                System.out.append(new String(out.toByteArray()));
            }
        }

        public final List<ByteArrayOutputStream> getOutputs() {
            return Util.makeArrayList(this.outs);
        }
    }

    private static final class SynchronizedUnmarshaller
    implements Unmarshaller {
        private final Unmarshaller delegate;

        private SynchronizedUnmarshaller(Unmarshaller delegate) {
            this.delegate = delegate;
        }

        public synchronized <A extends XmlAdapter> A getAdapter(Class<A> arg0) {
            return (A)this.delegate.getAdapter(arg0);
        }

        public synchronized AttachmentUnmarshaller getAttachmentUnmarshaller() {
            return this.delegate.getAttachmentUnmarshaller();
        }

        public synchronized ValidationEventHandler getEventHandler() throws JAXBException {
            return this.delegate.getEventHandler();
        }

        public synchronized Unmarshaller.Listener getListener() {
            return this.delegate.getListener();
        }

        public synchronized Object getProperty(String arg0) throws PropertyException {
            return this.delegate.getProperty(arg0);
        }

        public synchronized Schema getSchema() {
            return this.delegate.getSchema();
        }

        public synchronized UnmarshallerHandler getUnmarshallerHandler() {
            return this.delegate.getUnmarshallerHandler();
        }

        @Deprecated
        public synchronized boolean isValidating() throws JAXBException {
            return this.delegate.isValidating();
        }

        public synchronized <A extends XmlAdapter> void setAdapter(Class<A> arg0, A arg1) {
            this.delegate.setAdapter(arg0, arg1);
        }

        public synchronized void setAdapter(XmlAdapter arg0) {
            this.delegate.setAdapter(arg0);
        }

        public synchronized void setAttachmentUnmarshaller(AttachmentUnmarshaller arg0) {
            this.delegate.setAttachmentUnmarshaller(arg0);
        }

        public synchronized void setEventHandler(ValidationEventHandler arg0) throws JAXBException {
            this.delegate.setEventHandler(arg0);
        }

        public synchronized void setListener(Unmarshaller.Listener arg0) {
            this.delegate.setListener(arg0);
        }

        public synchronized void setProperty(String arg0, Object arg1) throws PropertyException {
            this.delegate.setProperty(arg0, arg1);
        }

        public synchronized void setSchema(Schema arg0) {
            this.delegate.setSchema(arg0);
        }

        @Deprecated
        public synchronized void setValidating(boolean arg0) throws JAXBException {
            this.delegate.setValidating(arg0);
        }

        public synchronized Object unmarshal(File arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(InputSource arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(InputStream arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(Node arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(Node arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(Reader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(Source arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(Source arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(URL arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(XMLEventReader arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(XMLEventReader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(XMLStreamReader arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(XMLStreamReader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }
    }

    private static final class SynchronizedMarshaller
    implements Marshaller {
        private final Marshaller delegate;

        private SynchronizedMarshaller(Marshaller delegate) {
            this.delegate = delegate;
        }

        public synchronized <A extends XmlAdapter> A getAdapter(Class<A> arg0) {
            return (A)this.delegate.getAdapter(arg0);
        }

        public synchronized AttachmentMarshaller getAttachmentMarshaller() {
            return this.delegate.getAttachmentMarshaller();
        }

        public synchronized ValidationEventHandler getEventHandler() throws JAXBException {
            return this.delegate.getEventHandler();
        }

        public synchronized Marshaller.Listener getListener() {
            return this.delegate.getListener();
        }

        public synchronized Node getNode(Object arg0) throws JAXBException {
            return this.delegate.getNode(arg0);
        }

        public synchronized Object getProperty(String arg0) throws PropertyException {
            return this.delegate.getProperty(arg0);
        }

        public synchronized Schema getSchema() {
            return this.delegate.getSchema();
        }

        public synchronized void marshal(Object arg0, ContentHandler arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, File arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Node arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, OutputStream arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Result arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Writer arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, XMLEventWriter arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, XMLStreamWriter arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized <A extends XmlAdapter> void setAdapter(Class<A> arg0, A arg1) {
            this.delegate.setAdapter(arg0, arg1);
        }

        public synchronized void setAdapter(XmlAdapter arg0) {
            this.delegate.setAdapter(arg0);
        }

        public synchronized void setAttachmentMarshaller(AttachmentMarshaller arg0) {
            this.delegate.setAttachmentMarshaller(arg0);
        }

        public synchronized void setEventHandler(ValidationEventHandler arg0) throws JAXBException {
            this.delegate.setEventHandler(arg0);
        }

        public synchronized void setListener(Marshaller.Listener arg0) {
            this.delegate.setListener(arg0);
        }

        public synchronized void setProperty(String arg0, Object arg1) throws PropertyException {
            this.delegate.setProperty(arg0, arg1);
        }

        public synchronized void setSchema(Schema arg0) {
            this.delegate.setSchema(arg0);
        }
    }

    private static final class CacheEntry {
        private Set<Class<?>> classSet;
        private JAXBContext context;

        CacheEntry() {
        }
    }

    private static final class LazyDocumentBuilder {
        private static DocumentBuilder value;

        private LazyDocumentBuilder() {
        }

        private static final synchronized void initDocumentBuilder() throws ParserConfigurationException {
            if (value == null) {
                value = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Document createDocument() throws ParserConfigurationException {
            LazyDocumentBuilder.initDocumentBuilder();
            DocumentBuilder documentBuilder = value;
            synchronized (documentBuilder) {
                return value.newDocument();
            }
        }
    }

    private static final class TransformerFactoryHolder {
        private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

        private TransformerFactoryHolder() {
        }
    }
}

