/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchemaException;

public class WSDLServiceFactory
extends AbstractServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLServiceFactory.class);
    private URL wsdlUrl;
    private QName serviceName;
    private QName endpointName;
    private Definition definition;

    public WSDLServiceFactory(Bus b, Definition d) {
        this.setBus(b);
        this.definition = d;
    }

    public WSDLServiceFactory(Bus b, Definition d, QName sn) {
        this(b, d);
        this.serviceName = sn;
    }

    public WSDLServiceFactory(Bus b, URL url) {
        this.setBus(b);
        this.wsdlUrl = url;
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.wsdlUrl);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
    }

    public WSDLServiceFactory(Bus b, String url) {
        this.setBus(b);
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(url);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
    }

    public WSDLServiceFactory(Bus b, URL url, QName sn) {
        this(b, url);
        this.serviceName = sn;
    }

    public WSDLServiceFactory(Bus b, String url, QName sn) {
        this.setBus(b);
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(url);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
        this.serviceName = sn;
    }

    public void setEndpointName(QName qn) {
        this.endpointName = qn;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Service create() {
        List<ServiceInfo> services;
        if (this.serviceName == null) {
            try {
                services = new WSDLServiceBuilder(this.getBus()).buildServices(this.definition);
            }
            catch (XmlSchemaException ex) {
                throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
            }
            if (services.size() == 0) {
                throw new ServiceConstructionException(new Message("NO_SERVICE_EXC", LOG, new Object[0]));
            }
            this.serviceName = services.get(0).getName();
            Iterator<ServiceInfo> it = services.iterator();
            while (it.hasNext()) {
                if (it.next().getName().equals(this.serviceName)) continue;
                it.remove();
            }
        } else {
            javax.wsdl.Service wsdlService = this.definition.getService(this.serviceName);
            if (wsdlService == null) {
                throw new ServiceConstructionException(new Message("NO_SUCH_SERVICE_EXC", LOG, new Object[]{this.serviceName}));
            }
            try {
                services = new WSDLServiceBuilder(this.getBus()).buildServices(this.definition, wsdlService, this.endpointName);
                if (services.size() == 0) {
                    throw new ServiceConstructionException(new Message("NO_SUCH_ENDPOINT_EXC", LOG, new Object[]{this.endpointName}));
                }
            }
            catch (XmlSchemaException ex) {
                throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
            }
        }
        ServiceImpl service = new ServiceImpl(services);
        this.setService(service);
        return service;
    }
}

