/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.OutputStream;
import java.io.PrintStream;

public class PrefixingStream
extends PrintStream {
    private final Prefixer prefixer;
    private boolean newline = true;

    public PrefixingStream(Prefixer prefixer, OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        assert (prefixer != null);
        this.prefixer = prefixer;
    }

    public PrefixingStream(Prefixer prefixer, OutputStream out) {
        this(prefixer, out, false);
    }

    public PrefixingStream(final String prefix, OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.prefixer = new Prefixer(){

            public String prefix(String context) {
                return prefix;
            }
        };
    }

    public PrefixingStream(String prefix, OutputStream out) {
        this(prefix, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) {
        assert (b != null);
        assert (off > -1);
        assert (len > -1);
        PrefixingStream prefixingStream = this;
        synchronized (prefixingStream) {
            if (this.newline) {
                String result = this.prefixer.prefix(new String(b, off, len));
                if (result != null) {
                    byte[] prefix = result.getBytes();
                    super.write(prefix, 0, prefix.length);
                }
                this.newline = false;
            }
            super.write(b, off, len);
        }
        for (int i = off; i < len; ++i) {
            if (b[i] != 10) continue;
            PrefixingStream prefixingStream2 = this;
            synchronized (prefixingStream2) {
                this.newline = true;
                break;
            }
        }
    }

    public static interface Prefixer {
        public String prefix(String var1);
    }
}

