/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

public final class NullCryptor
extends Cryptor {
    public static final NullCryptor Instance = new NullCryptor();

    private NullCryptor() {
    }

    @Override
    public Envelope encrypt(String plainText, CertID encryptFor) {
        return Envelope.unencrypted(plainText);
    }

    @Override
    public Envelope encrypt(String plainText, CertData encryptFor) {
        return Envelope.unencrypted(plainText);
    }

    @Override
    public String decrypt(Envelope cipherText) {
        if (cipherText == null) {
            return null;
        }
        return cipherText.getData();
    }

    @Override
    public Envelope sign(Envelope encryptedData) {
        return encryptedData;
    }

    @Override
    public boolean verify(Envelope encryptedData) {
        return true;
    }
}

