/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBuilder
implements Cloneable {
    protected URI base;
    private final String ENC = "UTF-8";

    public URIBuilder(String url) throws URISyntaxException {
        this.base = new URI(url);
    }

    public URIBuilder(URL url) throws URISyntaxException {
        this.base = url.toURI();
    }

    public URIBuilder(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        this.base = uri;
    }

    public static URI convertToURI(Object uri) throws URISyntaxException {
        if (uri instanceof URI) {
            return (URI)uri;
        }
        if (uri instanceof URL) {
            return ((URL)uri).toURI();
        }
        if (uri instanceof URIBuilder) {
            return ((URIBuilder)uri).toURI();
        }
        return new URI(uri.toString());
    }

    public URIBuilder setScheme(String scheme) throws URISyntaxException {
        this.base = new URI(scheme, this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setPort(int port) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), port, this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setHost(String host) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), host, this.base.getPort(), this.base.getPath(), this.base.getQuery(), this.base.getFragment());
        return this;
    }

    public URIBuilder setPath(String path) throws URISyntaxException {
        this.base = this.base.resolve(new URI(null, null, path, this.base.getQuery(), this.base.getFragment()));
        return this;
    }

    protected URIBuilder setQueryNVP(List<NameValuePair> nvp) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        String path = this.base.getRawPath();
        if (path != null) {
            sb.append(path);
        }
        sb.append('?');
        sb.append(URLEncodedUtils.format(nvp, (String)"UTF-8"));
        String frag = this.base.getRawFragment();
        if (frag != null) {
            sb.append('#').append(frag);
        }
        this.base = this.base.resolve(sb.toString());
        return this;
    }

    public URIBuilder setQuery(Map<?, ?> params) throws URISyntaxException {
        if (params == null || params.size() < 1) {
            this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), null, this.base.getFragment());
        } else {
            ArrayList<NameValuePair> nvp = new ArrayList<NameValuePair>(params.size());
            for (Object key : params.keySet()) {
                Object value = params.get(key);
                if (value instanceof List) {
                    for (Object val : (List)value) {
                        nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), val != null ? val.toString() : ""));
                    }
                    continue;
                }
                nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), value != null ? value.toString() : ""));
            }
            this.setQueryNVP(nvp);
        }
        return this;
    }

    public Map<String, Object> getQuery() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<NameValuePair> pairs = this.getQueryNVP();
        for (NameValuePair pair : pairs) {
            String key = pair.getName();
            Object existing = params.get(key);
            if (existing == null) {
                params.put(key, pair.getValue());
                continue;
            }
            if (existing instanceof List) {
                ((List)existing).add(pair.getValue());
                continue;
            }
            ArrayList<String> vals = new ArrayList<String>(2);
            vals.add((String)existing);
            vals.add(pair.getValue());
            params.put(key, vals);
        }
        return params;
    }

    protected List<NameValuePair> getQueryNVP() {
        List nvps = URLEncodedUtils.parse((URI)this.base, (String)"UTF-8");
        ArrayList<NameValuePair> newList = new ArrayList<NameValuePair>();
        if (nvps != null) {
            newList.addAll(nvps);
        }
        return newList;
    }

    public boolean hasQueryParam(String name) {
        return this.getQuery().get(name) != null;
    }

    public URIBuilder removeQueryParam(String param) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        NameValuePair found = null;
        for (NameValuePair nvp : params) {
            if (!nvp.getName().equals(param)) continue;
            found = nvp;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("Param '" + param + "' not found");
        }
        params.remove(found);
        this.setQueryNVP(params);
        return this;
    }

    protected URIBuilder addQueryParam(NameValuePair nvp) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        params.add(nvp);
        this.setQueryNVP(params);
        return this;
    }

    public URIBuilder addQueryParam(String param, Object value) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        params.add((NameValuePair)new BasicNameValuePair(param, value != null ? value.toString() : ""));
        this.setQueryNVP(params);
        return this;
    }

    protected URIBuilder addQueryParams(List<NameValuePair> nvp) throws URISyntaxException {
        List<NameValuePair> params = this.getQueryNVP();
        params.addAll(nvp);
        this.setQueryNVP(params);
        return this;
    }

    public URIBuilder addQueryParams(Map<?, ?> params) throws URISyntaxException {
        ArrayList<NameValuePair> nvp = new ArrayList<NameValuePair>();
        for (Object key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), val != null ? val.toString() : ""));
                }
                continue;
            }
            nvp.add((NameValuePair)new BasicNameValuePair(key.toString(), value != null ? value.toString() : ""));
        }
        this.addQueryParams(nvp);
        return this;
    }

    public URIBuilder setFragment(String fragment) throws URISyntaxException {
        this.base = new URI(this.base.getScheme(), this.base.getUserInfo(), this.base.getHost(), this.base.getPort(), this.base.getPath(), this.base.getQuery(), fragment);
        return this;
    }

    public String toString() {
        return this.base.toString();
    }

    public URL toURL() throws MalformedURLException {
        return this.base.toURL();
    }

    public URI toURI() {
        return this.base;
    }

    public Object asType(Class<?> type) throws MalformedURLException {
        if (type == URI.class) {
            return this.toURI();
        }
        if (type == URL.class) {
            return this.toURL();
        }
        if (type == String.class) {
            return this.toString();
        }
        throw new ClassCastException("Cannot cast instance of URIBuilder to class " + type);
    }

    protected URIBuilder clone() {
        return new URIBuilder(this.base);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URIBuilder)) {
            return false;
        }
        return this.base.equals(((URIBuilder)obj).toURI());
    }
}

