/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class AntStructure
extends Task {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private File output;
    private StructurePrinter printer = new DTDPrinter();
    static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskContainer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    public void setOutput(File output) {
        this.output = output;
    }

    public void add(StructurePrinter p) {
        this.printer = p;
    }

    public void execute() throws BuildException {
        if (this.output == null) {
            throw new BuildException("output attribute is required", this.getLocation());
        }
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), "UTF8"));
            }
            catch (UnsupportedEncodingException ue) {
                out = new PrintWriter(new FileWriter(this.output));
            }
            this.printer.printHead(out, this.getProject(), new Hashtable(this.getProject().getTaskDefinitions()), new Hashtable(this.getProject().getDataTypeDefinitions()));
            this.printer.printTargetDecl(out);
            Iterator dataTypes = this.getProject().getCopyOfDataTypeDefinitions().keySet().iterator();
            while (dataTypes.hasNext()) {
                String typeName = (String)dataTypes.next();
                this.printer.printElementDecl(out, this.getProject(), typeName, (Class)this.getProject().getDataTypeDefinitions().get(typeName));
            }
            Iterator tasks = this.getProject().getCopyOfTaskDefinitions().keySet().iterator();
            while (tasks.hasNext()) {
                String tName = (String)tasks.next();
                this.printer.printElementDecl(out, this.getProject(), tName, (Class)this.getProject().getTaskDefinitions().get(tName));
            }
            this.printer.printTail(out);
            if (out.checkError()) {
                throw new IOException("Encountered an error writing Ant structure");
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Error writing " + this.output.getAbsolutePath(), ioe, this.getLocation());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected boolean isNmtoken(String s) {
        return DTDPrinter.isNmtoken(s);
    }

    protected boolean areNmtokens(String[] s) {
        return DTDPrinter.areNmtokens(s);
    }

    private static class DTDPrinter
    implements StructurePrinter {
        private static final String BOOLEAN = "%boolean;";
        private static final String TASKS = "%tasks;";
        private static final String TYPES = "%types;";
        private Hashtable visited = new Hashtable();

        private DTDPrinter() {
        }

        public void printTail(PrintWriter out) {
            this.visited.clear();
        }

        public void printHead(PrintWriter out, Project p, Hashtable tasks, Hashtable types) {
            this.printHead(out, tasks.keys(), types.keys());
        }

        private void printHead(PrintWriter out, Enumeration tasks, Enumeration types) {
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            out.println("<!ENTITY % boolean \"(true|false|on|off|yes|no)\">");
            out.print("<!ENTITY % tasks \"");
            boolean first = true;
            while (tasks.hasMoreElements()) {
                String tName = (String)tasks.nextElement();
                if (!first) {
                    out.print(" | ");
                } else {
                    first = false;
                }
                out.print(tName);
            }
            out.println("\">");
            out.print("<!ENTITY % types \"");
            first = true;
            while (types.hasMoreElements()) {
                String typeName = (String)types.nextElement();
                if (!first) {
                    out.print(" | ");
                } else {
                    first = false;
                }
                out.print(typeName);
            }
            out.println("\">");
            out.println("");
            out.print("<!ELEMENT project (target | extension-point | ");
            out.print(TASKS);
            out.print(" | ");
            out.print(TYPES);
            out.println(")*>");
            out.println("<!ATTLIST project");
            out.println("          name    CDATA #IMPLIED");
            out.println("          default CDATA #IMPLIED");
            out.println("          basedir CDATA #IMPLIED>");
            out.println("");
        }

        public void printTargetDecl(PrintWriter out) {
            out.print("<!ELEMENT target (");
            out.print(TASKS);
            out.print(" | ");
            out.print(TYPES);
            out.println(")*>");
            out.println("");
            this.printTargetAttrs(out, "target");
            out.println("<!ELEMENT extension-point EMPTY>");
            out.println("");
            this.printTargetAttrs(out, "extension-point");
        }

        private void printTargetAttrs(PrintWriter out, String tag) {
            out.print("<!ATTLIST ");
            out.println(tag);
            out.println("          id          ID    #IMPLIED");
            out.println("          name        CDATA #REQUIRED");
            out.println("          if          CDATA #IMPLIED");
            out.println("          unless      CDATA #IMPLIED");
            out.println("          depends     CDATA #IMPLIED");
            out.println("          extensionOf CDATA #IMPLIED");
            out.println("          description CDATA #IMPLIED>");
            out.println("");
        }

        public void printElementDecl(PrintWriter out, Project p, String name, Class element) {
            int i;
            int count;
            if (this.visited.containsKey(name)) {
                return;
            }
            this.visited.put(name, "");
            IntrospectionHelper ih = null;
            try {
                ih = IntrospectionHelper.getHelper(p, element);
            }
            catch (Throwable t) {
                return;
            }
            StringBuffer sb = new StringBuffer("<!ELEMENT ");
            sb.append(name).append(" ");
            if ((class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = AntStructure.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference).equals(element)) {
                sb.append("EMPTY>").append(LINE_SEP);
                sb.append("<!ATTLIST ").append(name);
                sb.append(LINE_SEP).append("          id ID #IMPLIED");
                sb.append(LINE_SEP).append("          refid IDREF #IMPLIED");
                sb.append(">").append(LINE_SEP);
                out.println(sb);
                return;
            }
            Vector<String> v = new Vector<String>();
            if (ih.supportsCharacters()) {
                v.addElement("#PCDATA");
            }
            if ((class$org$apache$tools$ant$TaskContainer == null ? (class$org$apache$tools$ant$TaskContainer = AntStructure.class$("org.apache.tools.ant.TaskContainer")) : class$org$apache$tools$ant$TaskContainer).isAssignableFrom(element)) {
                v.addElement(TASKS);
            }
            Enumeration e = ih.getNestedElements();
            while (e.hasMoreElements()) {
                v.addElement((String)e.nextElement());
            }
            if (v.isEmpty()) {
                sb.append("EMPTY");
            } else {
                sb.append("(");
                count = v.size();
                for (i = 0; i < count; ++i) {
                    if (i != 0) {
                        sb.append(" | ");
                    }
                    sb.append(v.elementAt(i));
                }
                sb.append(")");
                if (count > 1 || !v.elementAt(0).equals("#PCDATA")) {
                    sb.append("*");
                }
            }
            sb.append(">");
            out.println(sb);
            sb = new StringBuffer("<!ATTLIST ");
            sb.append(name);
            sb.append(LINE_SEP).append("          id ID #IMPLIED");
            e = ih.getAttributes();
            while (e.hasMoreElements()) {
                block33: {
                    String attrName = (String)e.nextElement();
                    if ("id".equals(attrName)) continue;
                    sb.append(LINE_SEP).append("          ").append(attrName).append(" ");
                    Class type = ih.getAttributeType(attrName);
                    if (type.equals(class$java$lang$Boolean == null ? AntStructure.class$("java.lang.Boolean") : class$java$lang$Boolean) || type.equals(Boolean.TYPE)) {
                        sb.append(BOOLEAN).append(" ");
                    } else if ((class$org$apache$tools$ant$types$Reference == null ? AntStructure.class$("org.apache.tools.ant.types.Reference") : class$org$apache$tools$ant$types$Reference).isAssignableFrom(type)) {
                        sb.append("IDREF ");
                    } else if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? AntStructure.class$("org.apache.tools.ant.types.EnumeratedAttribute") : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(type)) {
                        try {
                            EnumeratedAttribute ea = (EnumeratedAttribute)type.newInstance();
                            String[] values = ea.getValues();
                            if (values == null || values.length == 0 || !DTDPrinter.areNmtokens(values)) {
                                sb.append("CDATA ");
                                break block33;
                            }
                            sb.append("(");
                            for (int i2 = 0; i2 < values.length; ++i2) {
                                if (i2 != 0) {
                                    sb.append(" | ");
                                }
                                sb.append(values[i2]);
                            }
                            sb.append(") ");
                        }
                        catch (InstantiationException ie) {
                            sb.append("CDATA ");
                        }
                        catch (IllegalAccessException ie) {
                            sb.append("CDATA ");
                        }
                    } else if (type.getSuperclass() != null && type.getSuperclass().getName().equals("java.lang.Enum")) {
                        try {
                            Object[] values = (Object[])type.getMethod("values", null).invoke(null, (Object[])null);
                            if (values.length == 0) {
                                sb.append("CDATA ");
                                break block33;
                            }
                            sb.append('(');
                            for (int i3 = 0; i3 < values.length; ++i3) {
                                if (i3 != 0) {
                                    sb.append(" | ");
                                }
                                sb.append(type.getMethod("name", null).invoke(values[i3], (Object[])null));
                            }
                            sb.append(") ");
                        }
                        catch (Exception x) {
                            sb.append("CDATA ");
                        }
                    } else {
                        sb.append("CDATA ");
                    }
                }
                sb.append("#IMPLIED");
            }
            sb.append(">").append(LINE_SEP);
            out.println(sb);
            count = v.size();
            for (i = 0; i < count; ++i) {
                String nestedName = (String)v.elementAt(i);
                if ("#PCDATA".equals(nestedName) || TASKS.equals(nestedName) || TYPES.equals(nestedName)) continue;
                this.printElementDecl(out, p, nestedName, ih.getElementType(nestedName));
            }
        }

        public static final boolean isNmtoken(String s) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':') continue;
                return false;
            }
            return true;
        }

        public static final boolean areNmtokens(String[] s) {
            for (int i = 0; i < s.length; ++i) {
                if (DTDPrinter.isNmtoken(s[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface StructurePrinter {
        public void printHead(PrintWriter var1, Project var2, Hashtable var3, Hashtable var4);

        public void printTargetDecl(PrintWriter var1);

        public void printElementDecl(PrintWriter var1, Project var2, String var3, Class var4);

        public void printTail(PrintWriter var1);
    }
}

