/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model.io.props;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context
implements Cloneable {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Map<String, String> store;
    private String prefix;
    private Context parent;

    private Context(Map<String, String> store, String prefix) {
        assert (store != null);
        this.store = store;
        this.prefix = prefix;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getClass().getSimpleName());
        buff.append("[").append(NEWLINE);
        if (this.prefix != null) {
            for (Map.Entry<String, String> entry : this.store.entrySet()) {
                if (!entry.getKey().startsWith(this.prefix)) continue;
                buff.append("  ").append(entry.getKey()).append("=").append(entry.getValue()).append(",").append(NEWLINE);
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String key(String name) {
        assert (name != null);
        if (this.prefix != null) {
            return this.prefix + "." + name;
        }
        return name;
    }

    public boolean contains(String name) {
        assert (name != null);
        return this.store.containsKey(this.key(name));
    }

    public String set(String name, String value) {
        assert (name != null);
        assert (value != null);
        return this.store.put(this.key(name), value);
    }

    public String get(String name, String defaultValue) {
        assert (name != null);
        String value = this.store.get(this.key(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public int size() {
        if (this.prefix == null) {
            return this.store.size();
        }
        int c = 0;
        for (String key : this.store.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            ++c;
        }
        return c;
    }

    public Set<String> names() {
        if (this.prefix == null) {
            return Collections.unmodifiableSet(this.store.keySet());
        }
        HashSet<String> matching = new HashSet<String>();
        int l = this.prefix.length();
        for (String key : this.store.keySet()) {
            if (!key.startsWith(this.prefix + ".")) continue;
            key = key.substring(l + 1, key.length());
            matching.add(key);
        }
        return Collections.unmodifiableSet(matching);
    }

    public Context parent() {
        if (this.parent == null) {
            throw new IllegalStateException("Parent is not bound");
        }
        return this.parent;
    }

    public Context child(String prefix) {
        assert (prefix != null);
        Context child = (Context)this.clone();
        child.parent = this;
        child.prefix = child.prefix != null ? child.prefix + "." + prefix : prefix;
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context create(URL input) throws IOException {
        Properties props;
        assert (input != null);
        InputStream in = input.openStream();
        try {
            props = new Properties();
            if (input.getFile().toLowerCase().endsWith(".xml")) {
                props.loadFromXML(in);
            }
            props.load(in);
        }
        finally {
            in.close();
        }
        Context ctx = new Context(props, null);
        return ctx;
    }

    public static Properties asProperties(Context ctx) {
        assert (ctx != null);
        Properties props = new Properties();
        for (String key : ctx.names()) {
            String value = ctx.get(key);
            props.setProperty(key, value);
        }
        return props;
    }

    public Properties toProperties() {
        return Context.asProperties(this);
    }

    public String[] split(String name, boolean trim) {
        String[] strings = this.get(name, "").split(",");
        if (trim) {
            strings = Context.trim(strings);
        }
        return strings;
    }

    public static String[] trim(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }
}

