/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.listener.Listener;
import org.sonatype.gossip.model.ListenerNode;
import org.sonatype.gossip.model.LoggerNode;
import org.sonatype.gossip.model.ProfileNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EffectiveProfile {
    private static final Logger log = Log.getLogger(EffectiveProfile.class);
    private final List<ProfileNode> profiles = new ArrayList<ProfileNode>();
    private Map<String, LoggerNode> loggers;
    private Listener[] listeners;

    public List<ProfileNode> getProfiles() {
        return this.profiles;
    }

    public void addProfile(ProfileNode node) {
        assert (node != null);
        this.getProfiles().add(node);
    }

    public Map<String, LoggerNode> loggers() {
        if (this.loggers == null) {
            log.trace("Loading effective logger table");
            HashMap<String, LoggerNode> map = new HashMap<String, LoggerNode>();
            for (ProfileNode profile : this.getProfiles()) {
                for (LoggerNode node : profile.getLoggers()) {
                    map.put(node.getName(), node);
                }
            }
            this.loggers = map;
        }
        return this.loggers;
    }

    public void dispatch(Event event) {
        assert (event != null);
        if (this.listeners == null) {
            log.trace("Building listener dispatch table");
            ArrayList<Listener> listeners = new ArrayList<Listener>();
            for (ProfileNode profile : this.getProfiles()) {
                for (ListenerNode listenerNode : profile.getListeners()) {
                    try {
                        log.trace("Adding listener: {}", (Object)listenerNode);
                        listeners.add(listenerNode.create());
                    }
                    catch (Exception e) {
                        log.error("Failed to create listener: " + listenerNode, (Throwable)e);
                    }
                }
            }
            this.listeners = listeners.toArray(new Listener[listeners.size()]);
        }
        log.trace("Dispatching event to {} listener(s): {}", (Object)this.listeners.length, (Object)event);
        int i = 0;
        for (Listener listener : this.listeners) {
            log.trace("Dispatching to listener[{}]: {}", (Object)i, (Object)listener);
            try {
                listener.onEvent(event);
            }
            catch (Throwable t) {
                log.error("Listener execution failed; ignoring", t);
            }
            ++i;
        }
    }
}

