/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.listener;

import java.io.File;
import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.listener.CountingWriter;
import org.sonatype.gossip.listener.FileListener;

public class FileSizeRollingStrategy
implements FileListener.RollingStrategy {
    private static final Logger log = Log.getLogger(FileSizeRollingStrategy.class);
    private long maximumFileSize = 0xA00000L;
    private int maximumBackupIndex = 1;

    public int getMaximumBackupIndex() {
        return this.maximumBackupIndex;
    }

    public void setMaximumBackupIndex(int n) {
        this.maximumBackupIndex = n;
    }

    public long getMaximumFileSize() {
        return this.maximumFileSize;
    }

    public void setMaximumFileSize(long n) {
        this.maximumFileSize = n;
    }

    public boolean roll(FileListener listener) {
        assert (listener != null);
        CountingWriter writer = listener.getWriter();
        if (writer.size() > this.maximumFileSize) {
            return false;
        }
        File source = listener.getFile();
        boolean renameSucceeded = true;
        if (this.maximumBackupIndex > 0) {
            File target;
            File file = new File(source.getPath() + '.' + this.maximumBackupIndex);
            if (file.exists()) {
                renameSucceeded = file.delete();
            }
            for (int i = this.maximumBackupIndex - 1; i >= 1 && renameSucceeded; --i) {
                file = new File(source.getPath() + "." + i);
                if (!file.exists()) continue;
                target = new File(source.getPath() + '.' + (i + 1));
                log.debug("Renaming file {} to {}", (Object)file, (Object)target);
                renameSucceeded = file.renameTo(target);
            }
            if (renameSucceeded) {
                target = new File(source.getPath() + "." + 1);
                file = new File(source.getPath());
                log.debug("Renaming file {} to {}", (Object)file, (Object)target);
                renameSucceeded = file.renameTo(target);
                if (!renameSucceeded) {
                    return false;
                }
            }
        }
        return true;
    }
}

