/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.listener;

import org.slf4j.Logger;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Level;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.listener.Listener;
import org.sonatype.gossip.render.PatternRenderer;
import org.sonatype.gossip.render.Renderer;

public abstract class ListenerSupport
implements Listener {
    protected final Logger log = Log.getLogger(this.getClass());
    private Renderer renderer;
    private Level threshold = Level.TRACE;

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected Renderer createRenderer() {
        return new PatternRenderer();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public void setThreshold(String threshold) {
        assert (threshold != null);
        this.setThreshold(Level.valueOf(threshold));
    }

    protected final boolean isLoggable(Event event) {
        assert (event != null);
        return this.threshold == null || event.getLevel().id >= this.threshold.id;
    }

    protected String render(Event event) {
        assert (event != null);
        Renderer renderer = this.getRenderer();
        if (renderer == null) {
            renderer = this.createRenderer();
            this.setRenderer(renderer);
        }
        return renderer.render(event);
    }
}

