/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model;

import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.listener.Listener;
import org.sonatype.gossip.model.FactoryNode;
import org.sonatype.gossip.model.ListenerNode;
import org.sonatype.gossip.model.SourceNode;
import org.sonatype.gossip.model.TriggerNode;
import org.sonatype.gossip.model.io.props.Context;
import org.sonatype.gossip.model.io.props.ContextConfigurator;
import org.sonatype.gossip.source.Source;
import org.sonatype.gossip.trigger.Trigger;

public class ComponentFactory {
    private static Logger log = Log.getLogger(ComponentFactory.class);

    public static Source create(SourceNode node) throws Exception {
        return (Source)ComponentFactory.build(node);
    }

    public static Trigger create(TriggerNode node) throws Exception {
        return (Trigger)ComponentFactory.build(node);
    }

    public static Listener create(ListenerNode node) throws Exception {
        return (Listener)ComponentFactory.build(node);
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        assert (className != null);
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(className);
        log.trace("Loaded class: {}", type);
        return type;
    }

    private static Object build(FactoryNode node) throws Exception {
        assert (node != null);
        return ComponentFactory.build(node.getType(), node.getConfiguration());
    }

    public static Object build(String className, Object config) throws Exception {
        assert (className != null);
        Class type = ComponentFactory.loadClass(className);
        Object obj = type.newInstance();
        if (config != null) {
            if (config instanceof Context) {
                new ContextConfigurator().configure(obj, (Context)config);
            } else {
                log.error("Unsupported configuration type: " + config.getClass().getName());
            }
        }
        log.trace("Created: {}", obj);
        return obj;
    }
}

