/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sonatype.gossip.model.ProfileNode;
import org.sonatype.gossip.model.SourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
implements Serializable {
    private String version;
    private Properties properties;
    private List<SourceNode> sources;
    private List<ProfileNode> profiles;
    private String modelEncoding = "UTF-8";

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<ProfileNode> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<ProfileNode>();
        }
        return this.profiles;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public List<SourceNode> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceNode>();
        }
        return this.sources;
    }

    public String getVersion() {
        return this.version;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setProfiles(List<ProfileNode> profiles) {
        this.profiles = profiles;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setSources(List<SourceNode> sources) {
        this.sources = sources;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProfileNode findProfile(String name) {
        assert (name != null);
        for (ProfileNode profile : this.getProfiles()) {
            if (!profile.getName().trim().equals(name)) continue;
            return profile;
        }
        return null;
    }
}

