/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.model.ProfileNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMerger {
    public void merge(Model target, Model source, boolean sourceDominant, Map<?, ?> hints) {
        assert (target != null);
        if (source == null) {
            return;
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (hints != null) {
            context.putAll(hints);
        }
        this.mergeModel(target, source, sourceDominant, context);
    }

    protected void mergeModel(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeModel_Properties(target, source, sourceDominant, context);
        this.mergeModel_Profiles(target, source, sourceDominant, context);
    }

    protected void mergeModel_Properties(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Properties merged = new Properties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target.getProperties());
            merged.putAll((Map<?, ?>)source.getProperties());
        } else {
            merged.putAll((Map<?, ?>)source.getProperties());
            merged.putAll((Map<?, ?>)target.getProperties());
        }
        target.setProperties(merged);
    }

    protected void mergeModel_Profiles(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        List<ProfileNode> src = source.getProfiles();
        if (!src.isEmpty()) {
            String key;
            List<ProfileNode> profiles = target.getProfiles();
            LinkedHashMap<String, ProfileNode> merged = new LinkedHashMap<String, ProfileNode>((src.size() + profiles.size()) * 2);
            for (ProfileNode element : profiles) {
                key = element.getName();
                merged.put(key, element);
            }
            for (ProfileNode element : src) {
                key = element.getName();
                if (!sourceDominant && merged.containsKey(key)) continue;
                merged.put(key, element);
            }
            target.setProfiles(new ArrayList<ProfileNode>(merged.values()));
        }
    }
}

