/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model.io.props;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.model.ComponentFactory;
import org.sonatype.gossip.model.io.props.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextConfigurator {
    private static final Logger log = Log.getLogger(ContextConfigurator.class);

    public void configure(Object target, Context config) throws Exception {
        assert (target != null);
        assert (config != null);
        for (String name : config.names()) {
            String value;
            int i = name.indexOf(".");
            if (i != -1) {
                name = name.substring(0, i);
            }
            if (this.maybeSet(target, name, value = config.get(name))) continue;
            Object obj = ComponentFactory.build(value, config.child(name));
            Class<?> type = obj.getClass();
            name = this.getSetterName(name);
            block1: for (Method method : target.getClass().getMethods()) {
                Class<?>[] args;
                if (!method.getName().equals(name) || (args = method.getParameterTypes()).length != 1) continue;
                for (Class<?> arg : args) {
                    if (!arg.isAssignableFrom(type)) continue;
                    method.invoke(target, obj);
                    continue block1;
                }
            }
        }
    }

    private boolean maybeSet(Object target, String name, String text) {
        assert (target != null);
        assert (name != null);
        assert (text != null);
        try {
            Method setter = this.selectSetter(target.getClass(), this.getSetterName(name));
            if (setter != null) {
                Class<Enum> type = setter.getParameterTypes()[0];
                log.trace("Setting '{}={}' via: {}", new Object[]{name, text, setter});
                Object value = null;
                if (type.isEnum()) {
                    value = this.selectEnum(type, text);
                } else if (type != String.class) {
                    PropertyEditor editor = PropertyEditorManager.findEditor(type);
                    if (editor != null) {
                        editor.setAsText(text);
                        value = editor.getValue();
                    } else {
                        log.trace("Unable to convert value {} to {}", (Object)text, type);
                        return false;
                    }
                }
                if (value != null) {
                    log.trace("Converted value: {}", value);
                } else {
                    value = text;
                }
                setter.invoke(target, value);
                return true;
            }
            log.trace("Missing setter for: {}", (Object)text);
        }
        catch (Exception e) {
            log.error("Failed to set '{}={}'", new Object[]{name, text, e});
        }
        return false;
    }

    private Enum<?> selectEnum(Class<Enum> type, String name) {
        assert (type != null);
        assert (name != null);
        for (Enum n : type.getEnumConstants()) {
            if (!n.name().equalsIgnoreCase(name)) continue;
            return n;
        }
        throw new IllegalArgumentException("No enum const " + type + "." + name);
    }

    private Method selectSetter(Class type, String name) {
        assert (type != null);
        assert (name != null);
        HashMap setters = new HashMap();
        for (Method method : type.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != 1) continue;
            setters.put(method.getParameterTypes()[0], method);
        }
        Method setter = null;
        if (setters.size() == 1) {
            setter = (Method)setters.entrySet().iterator().next().getValue();
        } else if (setters.size() > 1) {
            setter = (Method)setters.get(String.class);
        }
        return setter;
    }

    private String getSetterName(String name) {
        assert (name != null && name.length() != 0);
        return new StringBuilder(name.length() + 3).append("set").append(Character.toTitleCase(name.charAt(0))).append(name.substring(1)).toString();
    }
}

