/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.model.io.props;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.slf4j.Logger;
import org.sonatype.gossip.ConfigurationException;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.model.ListenerNode;
import org.sonatype.gossip.model.LoggerNode;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.model.ProfileNode;
import org.sonatype.gossip.model.SourceNode;
import org.sonatype.gossip.model.TriggerNode;
import org.sonatype.gossip.model.io.props.Context;

public class GossipPropertiesReader {
    private static final String EXPECTED_VERSION = "1.0.0";
    private static final String SOURCES = "sources";
    private static final String SOURCE_DOT = "source.";
    private static final String PROFILES = "profiles";
    private static final String PROFILE_DOT = "profile.";
    private static final String INCLUDES = "includes";
    private static final String PROPERTIES = "properties";
    private static final String LOGGER = "logger";
    private static final String TRIGGERS = "triggers";
    private static final String TRIGGER_DOT = "trigger.";
    private static final String LISTENERS = "listeners";
    private static final String LISTENER_DOT = "listener.";
    private static final Logger log = Log.getLogger(GossipPropertiesReader.class);

    public Model read(URL url) throws IOException {
        assert (url != null);
        Model model = new Model();
        Context ctx = Context.create(url);
        String tmp = ctx.get("version");
        if (!EXPECTED_VERSION.equals(tmp)) {
            throw new ConfigurationException("Invalid configuration version: " + tmp + ", expected: " + EXPECTED_VERSION);
        }
        model.setProperties(ctx.child(PROPERTIES).toProperties());
        this.configureSourceNodes(model, ctx);
        this.configureProfileNodes(model, ctx);
        return model;
    }

    private void configureSourceNodes(Model model, Context ctx) {
        assert (model != null);
        assert (ctx != null);
        if (!ctx.contains(SOURCES)) {
            return;
        }
        for (String name : ctx.split(SOURCES, true)) {
            if (name.length() == 0) {
                throw new ConfigurationException("Source name is blank");
            }
            log.trace("Configuring source: {}", (Object)name);
            SourceNode node = this.createSourceNode(name, ctx.get(SOURCE_DOT + name), ctx.child(SOURCE_DOT + name));
            model.getSources().add(node);
        }
    }

    private SourceNode createSourceNode(String id, String type, Context ctx) {
        assert (type != null);
        assert (ctx != null);
        log.trace("Configuring source: {} -> {}", (Object)type, (Object)ctx);
        SourceNode node = new SourceNode();
        node.setId(id);
        node.setType(type);
        node.setConfiguration(ctx);
        log.trace("Created: {}", (Object)node);
        return node;
    }

    private void configureProfileNodes(Model model, Context ctx) {
        assert (model != null);
        assert (ctx != null);
        if (!ctx.contains(PROFILES)) {
            return;
        }
        for (String name : ctx.split(PROFILES, true)) {
            if (name.length() == 0) {
                throw new ConfigurationException("Profile name is blank");
            }
            ProfileNode node = this.createProfileNode(name, ctx.child(PROFILE_DOT + name));
            model.getProfiles().add(node);
        }
    }

    private ProfileNode createProfileNode(String name, Context ctx) {
        assert (name != null);
        assert (ctx != null);
        log.trace("Configuring profile: {} -> {}", (Object)name, (Object)ctx);
        ProfileNode node = new ProfileNode();
        node.setId(name);
        node.setName(name);
        node.setProperties(ctx.child(PROPERTIES).toProperties());
        this.configureLoggerNodes(node, ctx.child(LOGGER));
        this.configureTriggerNodes(node, ctx);
        this.configureListenerNodes(node, ctx);
        String includes = ctx.get(INCLUDES);
        if (includes != null) {
            String[] profiles = Context.trim(includes.split(","));
            node.setIncludes(Arrays.asList(profiles));
        }
        log.trace("Created: {}", (Object)node);
        return node;
    }

    private void configureLoggerNodes(ProfileNode profile, Context ctx) {
        assert (profile != null);
        assert (ctx != null);
        for (String name : ctx.names()) {
            name = name.trim();
            String value = ctx.get(name);
            LoggerNode node = new LoggerNode();
            node.setId(name);
            node.setName(name);
            node.setLevel(value);
            log.trace("Created: {}", (Object)node);
            profile.getLoggers().add(node);
        }
    }

    private void configureTriggerNodes(ProfileNode profile, Context ctx) {
        assert (profile != null);
        assert (ctx != null);
        if (!ctx.contains(TRIGGERS)) {
            return;
        }
        for (String name : ctx.split(TRIGGERS, true)) {
            if (name.length() == 0) {
                throw new ConfigurationException("Trigger name is blank");
            }
            TriggerNode node = this.createTriggerNode(name, ctx.get(TRIGGER_DOT + name), ctx.child(TRIGGER_DOT + name));
            profile.getTriggers().add(node);
        }
    }

    private TriggerNode createTriggerNode(String id, String type, Context ctx) {
        assert (type != null);
        assert (ctx != null);
        log.trace("Configuring trigger: {} -> {}", (Object)type, (Object)ctx);
        TriggerNode node = new TriggerNode();
        node.setId(id);
        node.setType(type);
        node.setConfiguration(ctx);
        log.trace("Created: {}", (Object)node);
        return node;
    }

    private void configureListenerNodes(ProfileNode profile, Context ctx) {
        assert (profile != null);
        assert (ctx != null);
        if (!ctx.contains(LISTENERS)) {
            return;
        }
        for (String name : ctx.split(LISTENERS, true)) {
            if (name.length() == 0) {
                throw new ConfigurationException("Listener name is blank");
            }
            ListenerNode listener = this.createListenerNode(name, ctx.get(LISTENER_DOT + name), ctx.child(LISTENER_DOT + name));
            profile.getListeners().add(listener);
        }
    }

    private ListenerNode createListenerNode(String id, String type, Context ctx) {
        assert (type != null);
        assert (ctx != null);
        log.trace("Configuring listener: {} -> {}", (Object)type, (Object)ctx);
        ListenerNode node = new ListenerNode();
        node.setId(id);
        node.setType(type);
        node.setConfiguration(ctx);
        log.trace("Created: {}", (Object)node);
        return node;
    }
}

