/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.source;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.sonatype.gossip.ConfigurationException;
import org.sonatype.gossip.MissingPropertyException;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.source.SourceSupport;

public class SystemPropertySource
extends SourceSupport {
    private String name;

    public SystemPropertySource() {
    }

    public SystemPropertySource(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Model load() throws Exception {
        URL url;
        String value;
        block5: {
            if (this.name == null) {
                throw new MissingPropertyException("name");
            }
            value = System.getProperty(this.name);
            if (value == null) {
                this.log.trace("Unable to load; property not set: {}", (Object)this.name);
                return null;
            }
            url = null;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException e) {
                File file = new File(value);
                if (!file.exists()) break block5;
                url = file.toURI().toURL();
            }
        }
        if (url == null) {
            throw new ConfigurationException("Unable to load; unable to resolve target: " + value);
        }
        return this.load(url);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + '}';
    }
}

