/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.DefaultJavaClassCache;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import java.io.Serializable;

public class JavaClassContext
implements Serializable {
    private final JavaClassCache cache;
    private ClassLibrary classLibrary;
    private JavaDocBuilder builder;

    public JavaClassContext(JavaDocBuilder builder) {
        this.builder = builder;
        this.cache = new DefaultJavaClassCache();
    }

    public JavaClassContext(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
        this.cache = new DefaultJavaClassCache();
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public JavaClass getClassByName(String name) {
        JavaClass result = this.cache.getClassByName(name);
        if (result == null && this.builder != null) {
            result = this.builder.createBinaryClass(name);
            if (result != null) {
                this.add(result);
                result.setJavaClassContext(this);
            } else {
                result = this.builder.createUnknownClass(name);
                this.add(result);
            }
        }
        return result;
    }

    public JavaClass[] getClasses() {
        return this.cache.getClasses();
    }

    public void add(JavaClass javaClass) {
        this.cache.putClassByName(javaClass.getFullyQualifiedName(), javaClass);
    }

    public void add(String fullyQualifiedClassName) {
        this.classLibrary.add(fullyQualifiedClassName);
    }

    public Class getClass(String name) {
        return this.classLibrary.getClass(name);
    }
}

