/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaPackage
extends AbstractBaseJavaEntity {
    private String name;
    private Map allPackages;
    private Annotation[] annotations = new Annotation[0];
    private int lineNumber = -1;
    private List classes = new ArrayList();

    public JavaPackage() {
    }

    public JavaPackage(String name) {
        this(name, null);
    }

    public JavaPackage(String name, Map allPackages) {
        this.name = name;
        this.allPackages = allPackages;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void addClass(JavaClass clazz) {
        clazz.setJavaPackage(this);
        this.classes.add(clazz);
    }

    public JavaClass[] getClasses() {
        return this.classes.toArray(new JavaClass[this.classes.size()]);
    }

    public JavaPackage getParentPackage() {
        String parentName = this.name.substring(0, this.name.lastIndexOf("."));
        return (JavaPackage)this.allPackages.get(parentName);
    }

    public JavaPackage[] getSubPackages() {
        String expected = this.name + ".";
        Set packageKeys = this.allPackages.keySet();
        ArrayList retList = new ArrayList();
        Iterator iterator = packageKeys.iterator();
        while (iterator.hasNext()) {
            String pName = (String)iterator.next();
            if (!pName.startsWith(expected) || pName.substring(expected.length()).indexOf(".") > -1) continue;
            retList.add(this.allPackages.get(pName));
        }
        return retList.toArray(new JavaPackage[retList.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaPackage that = (JavaPackage)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name;
    }
}

