/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.HTTPBuilder;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.HttpResponseException;
import groovyx.net.http.ResponseParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHTTPBuilder
extends HTTPBuilder {
    public static final int DEFAULT_POOL_SIZE = 4;
    protected ExecutorService threadPool;

    public AsyncHTTPBuilder(Map<String, ?> args) throws URISyntaxException {
        int poolSize = 4;
        ExecutorService threadPool = null;
        if (args != null) {
            Object timeout;
            Object defaultContentType;
            Object poolSzArg;
            threadPool = (ExecutorService)args.get("threadPool");
            if (threadPool instanceof ThreadPoolExecutor) {
                poolSize = ((ThreadPoolExecutor)threadPool).getMaximumPoolSize();
            }
            if ((poolSzArg = args.get("poolSize")) != null) {
                poolSize = Integer.parseInt(poolSzArg.toString());
            }
            if (args.get("url") != null) {
                throw new IllegalArgumentException("The 'url' parameter is deprecated; use 'uri' instead");
            }
            Object defaultURI = args.get("uri");
            if (defaultURI != null) {
                super.setUri(defaultURI);
            }
            if ((defaultContentType = args.get("contentType")) != null) {
                super.setContentType(defaultContentType);
            }
            if ((timeout = args.get("timeout")) != null) {
                this.setTimeout((Integer)timeout);
            }
        }
        this.initThreadPools(poolSize, threadPool);
    }

    @Override
    protected Future<?> doRequest(final HTTPBuilder.RequestConfigDelegate delegate) {
        return this.threadPool.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return AsyncHTTPBuilder.this.doRequestSuper(delegate);
                }
                catch (Exception ex) {
                    AsyncHTTPBuilder.this.log.info((Object)("Exception thrown from response delegate: " + delegate), (Throwable)ex);
                    throw ex;
                }
            }
        });
    }

    private Object doRequestSuper(HTTPBuilder.RequestConfigDelegate delegate) throws IOException {
        return super.doRequest(delegate);
    }

    protected void initThreadPools(int poolSize, ExecutorService threadPool) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize may not be < 1");
        }
        BasicHttpParams params = this.client != null ? this.client.getParams() : new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)poolSize);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(poolSize));
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        this.threadPool = threadPool != null ? threadPool : new ThreadPoolExecutor(1, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    protected Object defaultSuccessHandler(HttpResponseDecorator resp, Object parsedData) throws ResponseParseException {
        return super.defaultSuccessHandler(resp, parsedData);
    }

    @Override
    protected void defaultFailureHandler(HttpResponseDecorator resp) throws HttpResponseException {
        super.defaultFailureHandler(resp);
    }

    public void setTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)super.getClient().getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)super.getClient().getParams(), (int)timeout);
    }

    public int getTimeout() {
        return HttpConnectionParams.getConnectionTimeout((HttpParams)super.getClient().getParams());
    }

    public ExecutorService getThreadExecutor() {
        return this.threadPool;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadPool.shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

