/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.listener;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.listener.CountingWriter;
import org.sonatype.gossip.listener.ListenerSupport;

public class FileListener
extends ListenerSupport {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    private File file;
    private boolean append;
    private int bufferSize = 8192;
    private RollingStrategy rollingStrategy;
    private CountingWriter writer;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFile(String fileName) {
        assert (fileName != null);
        this.setFile(new File(this.evaluate(fileName.trim())));
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public RollingStrategy getRollingStrategy() {
        return this.rollingStrategy;
    }

    public void setRollingStrategy(RollingStrategy s) {
        this.rollingStrategy = s;
    }

    public CountingWriter getWriter() {
        return this.writer;
    }

    protected CountingWriter createWriter() throws IOException {
        File file;
        File dir;
        if (this.writer != null) {
            this.writer.close();
        }
        if ((dir = (file = this.getFile()).getParentFile()) != null && !dir.isDirectory() && !dir.mkdirs()) {
            this.log.warn("Unable to create directory structure for: {}", (Object)file);
        }
        this.log.trace("Creating writer for file: {}", (Object)file);
        Writer writer = new FileWriter(file, this.isAppend());
        if (this.bufferSize > 0) {
            this.log.trace("Using buffer size: {}", (Object)this.bufferSize);
            writer = new BufferedWriter(writer, this.bufferSize);
        }
        return new CountingWriter(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event) throws Exception {
        assert (event != null);
        if (!this.isLoggable(event)) {
            return;
        }
        if (this.writer == null) {
            this.writer = this.createWriter();
        } else if (this.rollingStrategy != null && this.rollingStrategy.roll(this)) {
            this.writer = this.createWriter();
        }
        CountingWriter countingWriter = this.writer;
        synchronized (countingWriter) {
            this.writer.write(this.render(event));
            this.writer.flush();
        }
    }

    protected String evaluate(String input) {
        if (input != null) {
            Matcher matcher = PATTERN.matcher(input);
            while (matcher.find()) {
                Object rep = this.getProperty(matcher.group(1));
                if (rep == null) continue;
                input = input.replace(matcher.group(0), rep.toString());
                matcher.reset(input);
            }
        }
        return input;
    }

    protected Object getProperty(String name) {
        assert (name != null);
        return System.getProperty(name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "append=" + this.append + ", bufferSize=" + this.bufferSize + ", file=" + this.file + ", rollingStrategy=" + this.rollingStrategy + ", threshold=" + (Object)((Object)this.getThreshold()) + '}';
    }

    public static interface RollingStrategy {
        public boolean roll(FileListener var1);
    }
}

