/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.trigger;

import org.slf4j.Logger;
import org.sonatype.gossip.Log;
import org.sonatype.gossip.trigger.Trigger;

public abstract class NameValueTriggerSupport
implements Trigger {
    protected transient Logger log = Log.getLogger(this.getClass());
    private String name;
    private String value;
    private boolean trim = true;
    private boolean ignoreCase = true;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTrim(boolean flag) {
        this.trim = flag;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setIgnoreCase(boolean flag) {
        this.ignoreCase = flag;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    protected abstract String resolve();

    public boolean isActive() {
        assert (this.name != null);
        String have = this.resolve();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Checking active state; name={}, expect={}, found={}", new Object[]{this.name, this.value, have});
        }
        if (have == null) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        String want = this.value;
        if (this.trim) {
            want = want.trim();
            have = have.trim();
        }
        if (this.ignoreCase) {
            return want.equalsIgnoreCase(have);
        }
        return want.equals(have);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", trim=" + this.trim + ", ignoreCase=" + this.ignoreCase + '}';
    }
}

