/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.source;

import java.net.URL;
import org.sonatype.gossip.MissingPropertyException;
import org.sonatype.gossip.model.Model;
import org.sonatype.gossip.source.SourceSupport;

public class ResourceSource
extends SourceSupport {
    private String name;
    private ClassLoaderType classLoaderType = ClassLoaderType.TCL;
    private ClassLoader classLoader;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassLoaderType(ClassLoaderType type) {
        assert (type != null);
        this.classLoaderType = type;
    }

    public ClassLoaderType getClassLoaderType() {
        return this.classLoaderType;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            switch (this.classLoaderType) {
                case TCL: {
                    this.classLoader = Thread.currentThread().getContextClassLoader();
                    break;
                }
                case INTERNAL: {
                    this.classLoader = this.getClass().getClassLoader();
                    break;
                }
                case SYSTEM: {
                    this.classLoader = ClassLoader.getSystemClassLoader();
                }
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Model load() throws Exception {
        if (this.name == null) {
            throw new MissingPropertyException("name");
        }
        Model model = null;
        ClassLoader cl = this.getClassLoader();
        assert (cl != null);
        this.log.trace("Loading resource for name: {}, CL: {}", (Object)this.name, (Object)cl);
        URL url = cl.getResource(this.name);
        if (url == null) {
            this.log.trace("Unable to load; missing resource: {}", (Object)this.name);
        } else {
            this.log.trace("Loaded resource: {}", (Object)url);
            model = this.load(url);
        }
        return model;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + ", classLoaderType='" + (Object)((Object)this.classLoaderType) + '\'' + ", classLoader=" + this.classLoader + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClassLoaderType {
        TCL,
        INTERNAL,
        SYSTEM;

    }
}

