/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import net.shrine.crypto.ImproperlyConfiguredKeyStoreException;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreProblem;
import net.shrine.crypto.InvalidSignatureFormatProblem;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.util.NonEmptySeq;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CryptoErrors$ {
    public static final CryptoErrors$ MODULE$;
    private final String NoPrivateKeyInStore;
    private final String CouldNotFindCa;
    private final String CouldNotFindCaOrSigningQuery;

    static {
        new CryptoErrors$();
    }

    public String comma(Iterable<KeyStoreEntry> entries) {
        return ((TraversableOnce)entries.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final NonEmptySeq<String> apply(KeyStoreEntry x$1) {
                return x$1.aliases();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public final String NoPrivateKeyInStore() {
        return "Could not find a key in the KeyStore with a PrivateKey. Without one, SHRINE cannot sign messages.";
    }

    public final String CouldNotFindCa() {
        return "You must specify at least one ca cert alias corresponding to a PrivateKey entry for the Hub in a non PeerToPeer network";
    }

    public final String CouldNotFindCaOrSigningQuery() {
        return "There must be a public entry in the keystore corresponding to the Hub, and a private entry signed by it.";
    }

    public final String TooManyPrivateKeys(Iterable<KeyStoreEntry> entries) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There are ", " entries in the KeyStore with a PrivateKey. Please specify which one to use for signing queries under `privateKeyAlias` in the configuration file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)entries.size())}));
    }

    public final String CouldNotFindAlias(String alias) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find a KeyStore Entry corresponding to the alias '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{alias}));
    }

    public final String CouldNotFindCaAlias(Iterable<KeyStoreEntry> entries) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find a KeyStore Entry corresponding to the aliases '", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.comma(entries)}));
    }

    public final String NotSignedByCa(Iterable<KeyStoreEntry> entries, KeyStoreEntry caEntry) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The private entries `", "` were not signed by the ca entry `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.comma(entries), caEntry.aliases().first()}));
    }

    public final String PrivateEntryIsCaEntry(Iterable<String> aliases) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Your private cert must not also be your CA cert. Intersecting aliases: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aliases.mkString(", ")}));
    }

    public final String ExpiredCertificates(Iterable<KeyStoreEntry> entries) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following certificates have expired: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.comma(entries)}));
    }

    public final String IncorrectAliasMapping(Iterable<String> aliases, Iterable<KeyStoreEntry> entries) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The remote site aliases did not correspond to the aliases in the KeyStore.\\n  Remote Site aliases: `", "`\\n  KeyStore Aliases: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aliases.mkString(", "), this.comma(entries)}));
    }

    public Nothing$ noKeyError(KeyStoreEntry myEntry) {
        IllegalArgumentException illegalEntry = new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided keystore entry ", " did not have a private key"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myEntry})));
        ImproperlyConfiguredKeyStoreProblem problem = new ImproperlyConfiguredKeyStoreProblem((Option<Throwable>)new Some((Object)illegalEntry), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The KeyStore entry identified as the signing cert for this node did not provide a private key to sign with."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Please check the KeyStore entry with the alias `", "`."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myEntry.aliases().first()}))).toString());
        throw (Throwable)problem.throwable().get();
    }

    public Nothing$ invalidSiganatureFormat(byte[] bytes) {
        IllegalArgumentException illegalSignature = new IllegalArgumentException("Given a signature with bytes that are not valid CMSSignedData");
        InvalidSignatureFormatProblem problem = new InvalidSignatureFormatProblem(bytes, (Option<Throwable>)new Some((Object)illegalSignature));
        throw (Throwable)problem.throwable().get();
    }

    public ImproperlyConfiguredKeyStoreProblem configureError(String description) {
        return new ImproperlyConfiguredKeyStoreProblem((Option<Throwable>)new Some((Object)new ImproperlyConfiguredKeyStoreException(description)), description);
    }

    private CryptoErrors$() {
        MODULE$ = this;
    }
}

