/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.listener;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CountingWriter
extends FilterWriter {
    private long count = 0L;

    public CountingWriter(Writer out) {
        super(out);
    }

    public long size() {
        return this.count;
    }

    public void reset() {
        this.count = 0L;
    }

    public void write(int c) throws IOException {
        super.write(c);
        ++this.count;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.count += (long)(len - off);
    }

    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.count += (long)str.length();
    }
}

