package net.shrine.monitor

import groovy.sql.Sql

import au.com.bytecode.opencsv.CSVWriter
import java.sql.ResultSet

/**
 * @author Justin Quan
 * @date May 8, 2011
 * @link http://chip.org
 *       <p/>
 *       NOTICE: This software comes with NO guarantees whatsoever and is
 *       licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
class TableToCSV {
    def config;
    Sql sql;

    TableToCSV(config, Sql sql)
    {
        this.config = config
        this.sql = sql
    }

    def dumpSqlToCSV(String table) {
        def req = "SELECT * from " + table
        File f = new File(config.csvFile);
        CSVWriter writer = new CSVWriter(new FileWriter(f));

        sql.query(req, {
            ResultSet rs -> writer.writeAll(rs, true)
        })
        writer.flush();
        writer.close();
    }

    public static void main(String[] args)
    {
        def config = new ConfigSlurper().parse(new File(args[0]).toURL())
        def sql = Sql.newInstance(config.dbUrl, config.dbUser, config.dbPasswd ?: "", config.dbDriver)
        def audit = new TableToCSV(config, sql);
        audit.dumpSqlToCSV(config.table)
    }
}
