package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

import javax.xml.datatype.XMLGregorianCalendar;
import java.util.List;

/**
 * @author Andrew McMurry, MS
 *         <p/>
 *         With primary support from Children's Hospital Informatics Program @
 *         Harvard-MIT Health Sciences and Technology and
 *         <p/>
 *         Secondary support from the Harvard Medical School
 *         Center for BioMedical Informatics
 *         <p/>
 *         PHD candidate, Boston University Bioinformatics
 *         Member, I2b2 National Center for Biomedical Computing
 *         <p/>
 *         All works licensed under LGPL
 *         <p/>
 *         User: andy
 *         Date: Oct 19, 2010
 *         Time: 9:09:37 PM
 */
public class ReqResPair
{
    public class NodeResponse
    {
        String  queryMasterID;
        String  nodeID;
        int     setSize;

        XMLGregorianCalendar startTime;
        XMLGregorianCalendar    endTime;
    }

    private List<NodeResponse>  nodes = Util.makeArrayList();

    private RequestMessageType  request;
    private ResponseMessageType response;

    private String              queryMasterID;
    private CRCQueryStatus      status;

    private int panels = 0, items =0;

    private long tSTART;
    private long tEND;

    public ReqResPair(){}

    public void setRequest(RequestMessageType  request) throws SerializationException
    {
        this.request = request;

        QueryDefinitionType definition = CRCSerializer.getQueryDefinitionRequest(request).getQueryDefinition();

        panels  = definition.getPanel().size();

        for(PanelType panel : definition.getPanel())
        {
            items += panel.getItem().size();
        }
    }

    public void setResponse(ResponseMessageType response) throws SerializationException
    {
        this.response = response;

        status        = CRCSerializer.getQueryStatus(response);
        queryMasterID = CRCSerializer.getQueryMasterID(response);

        for(QueryResultInstanceType queryResult : CRCSerializer.getQueryResults(response))
        {
            NodeResponse node = new NodeResponse();
            //
                node.queryMasterID = queryMasterID;
                node.nodeID        = queryResult.getDescription();
                node.setSize       = queryResult.getSetSize();
                node.endTime       = queryResult.getStartDate();
                node.startTime     = queryResult.getEndDate();
            //

            nodes.add(node);
        }
    }

    public RequestMessageType getRequest()      {return request;}

    public ResponseMessageType getResponse()    {return response;}

    public void start() {tSTART = System.currentTimeMillis();}

    public void end()   {tEND   = System.currentTimeMillis();}

    public List<NodeResponse> getNodes() {
        return nodes;
    }

    public String getQueryMasterID() {
        return queryMasterID;
    }

    public CRCQueryStatus getStatus() {
        return status;
    }

    public int getPanels() {
        return panels;
    }

    public int getItems() {
        return items;
    }

    public long gettSTART() {
        return tSTART;
    }

    public long gettEND() {
        return tEND;
    }
}
