package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import net.shrine.serializers.crc.CRCHttpClient;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;

import java.io.IOException;
import java.util.concurrent.Callable;

/**
 * @author Andrew McMurry, MS
 *         <p/>
 *         With primary support from Children's Hospital Informatics Program @
 *         Harvard-MIT Health Sciences and Technology and
 *         <p/>
 *         Secondary support from the Harvard Medical School
 *         Center for BioMedical Informatics
 *         <p/>
 *         PHD candidate, Boston University Bioinformatics
 *         Member, I2b2 National Center for Biomedical Computing
 *         <p/>
 *         All works licensed under LGPL
 *         <p/>
 *         User: andy
 *         Date: Oct 19, 2010
 *         Time: 1:30:20 PM
 */
public class ReqThread implements Callable<ReqResPair>
{
    private String              url;
    private boolean             anonymize;
    private ReqResPair          pair;
    private OutputWriter        writer;

    public ReqThread(String crcURL, RequestMessageType request) throws IOException
    {
        url    = crcURL;
        writer = OutputWriter.getInstance();

        try
        {
            pair = new ReqResPair();
            pair.setRequest(request);
        }
        catch(Exception e)
        {
            writer.error("INVALID_REQUEST:RequestExecutor:", e);
        }
    }

    public ReqThread(String crcURL, RequestMessageType request, boolean anonymize) throws IOException
    {
        this(crcURL, request);

        this.anonymize = anonymize;
    }

    @Override
    public ReqResPair call() throws IOException
    {
        try
        {
            pair.setResponse(
                    CRCHttpClient.sendRequestToCRC(url,pair.getRequest())
            );

            if(pair.getStatus()!= CRCQueryStatus.COMPLETED)
            {
                writer.warn(pair.getStatus().name() +"query "+pair.getQueryMasterID() + " failed at the MASTER LEVEL ");
            }

            for(QueryResultInstanceType result : CRCSerializer.getQueryResults(pair.getResponse()))
            {
                /**
                 * NOTE: this is done to prevent accumulation of patient data at the point of the monitor.
                 * This is a configurable Runtime Args setting, default is FALSE
                 */

                if(anonymize) result.setSetSize(0);
                
                //TODO: Bill Refactor, gross!
                if(result.getQueryStatusType().getName().equals("COMPLETED"))
                {
                    writer.warn(pair.getStatus().name() +"query "+pair.getQueryMasterID() + " failed at the NODE level for "+result.getDescription());
                }
            }
        }
        catch(Exception e)
        {
            writer.error("INVALID_RESPONSE:CRCHttpClient.sendRequestToCRC(...):", e);
        }

        try
        {
            writer.write(pair);
        }
        catch(SerializationException e)
        {
            writer.error("INVALID_RESPONSE:writer.write(...):", e);
        }

        return pair; 
    }
}