package net.shrine.monitor.scanner;

/**
 * @author amcmurry
*/
public enum ShortHandNotation
{
    /**
     * New Query Definition
     */
    def,

    /**
     * Query alias name
     * TODO not yet supported
     */
    name,

    /**
     * 1..* panels per query
     */
    panel,

    /**
     * 1...* items per panel
     */
    item,

    /**
     * constrain by year "2001 onward"
     * TODO not yet supported
     */
    year1,

    /**
     * constrain by year "until 2002"
     * TODO not yet supported
     */
    year2,

    /**
     * End of File
     */
    end;

    public String print()
    {
        return "@"+name();
    }

    public static boolean isNotation(String string)
    {
        return string.contains("@");
    }

    public static ShortHandNotation parse(String string)
    {
        return ShortHandNotation.valueOf(string.replaceFirst("@", ""));
    }

}
