package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import org.spin.tools.FileUtils;
import org.spin.tools.StringTools;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author Andrew McMurry, MS
 *         <p/>
 *         With primary support from Children's Hospital Informatics Program @
 *         Harvard-MIT Health Sciences and Technology and
 *         <p/>
 *         Secondary support from the Harvard Medical School
 *         Center for BioMedical Informatics
 *         <p/>
 *         PHD candidate, Boston University Bioinformatics
 *         Member, I2b2 National Center for Biomedical Computing
 *         <p/>
 *         All works licensed under LGPL
 *         <p/>
 *         User: andy
 *         Date: Oct 19, 2010
 *         Time: 11:04:15 AM
 */
public class ShortHandNotationIO
{
    // BatchBuilder Label
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd#hh.mm.ssa");

    private static final String CRLF = StringTools.crlf();

    public static void write(File outputFile, List<QueryDefinitionType> queries) throws IOException
    {
        System.out.println("Writing to "+outputFile.getAbsolutePath());
        
        FileUtils.write(outputFile, read(queries));
    }

    public static void write(File outputFile, QueryDefinitionType ... queries) throws IOException
    {
        write(outputFile, Arrays.asList(queries));
    }

    public static String read(QueryDefinitionType ... queries)
    {
        return read(Arrays.asList(queries));
    }

    public static String read(List<QueryDefinitionType> queries)
    {
        //Domain Specific Language
        StringBuilder dsl = new StringBuilder();

        final String user   = System.getProperty("user.name");
        final String stamp  = format.format(new Date());

        dsl.append("# Generated by "    + CRLF);
        dsl.append("# user " + user     + CRLF);
        dsl.append("# time " + stamp    + CRLF);

        for(QueryDefinitionType query : queries)
        {
            dsl.append(ShortHandNotation.def.print());
            dsl.append(CRLF);

            if(query.getQueryName() !=null && query.getQueryName().length() > 0)
            {
                dsl.append(ShortHandNotation.panel.print());
                dsl.append(CRLF);
                dsl.append(query.getQueryName());
                dsl.append(CRLF);
            }

            for(PanelType panel : query.getPanel())
            {
                dsl.append(ShortHandNotation.panel.print());
                dsl.append(CRLF);

                for(ItemType item : panel.getItem())
                {
                    dsl.append(item.getItemKey());
                    dsl.append(CRLF);
                }
            }
            dsl.append(CRLF);
        }

        dsl.append(CRLF);
        dsl.append(ShortHandNotation.end.print());
        dsl.append(CRLF);

        return dsl.toString();
    }
}
