/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.shrine.monitor.scanner.ReqResPair;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.extension.BatchProcessing;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.FileUtils;
import org.spin.tools.StringTools;

public class OutputWriter {
    private File batch = BatchProcessing.getBatchProcessingLabel();
    private Writer queryWriter;
    private Writer panelWriter;
    private Writer nodeWriter;
    private Writer errorWriter;
    private Writer warningWriter;
    private static OutputWriter instance = null;
    private static String CSV = ",";
    private static String CRLF = StringTools.crlf();

    private OutputWriter() throws IOException {
        this.batch.mkdir();
        System.out.println("BATCH = " + this.batch.getAbsolutePath());
        this.queryWriter = this.getWriter("query_input.csv");
        this.panelWriter = this.getWriter("panel_input.csv");
        this.nodeWriter = this.getWriter("node_output.csv");
        this.errorWriter = this.getWriter("error.log");
        this.warningWriter = this.getWriter("warn.log");
        this.headers();
    }

    public static OutputWriter getInstance() throws IOException {
        if (instance == null) {
            instance = new OutputWriter();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(ReqResPair pair) throws IOException, SerializationException {
        this.xml(pair);
        Writer writer = this.queryWriter;
        synchronized (writer) {
            this.queryWriter.write(this.csvQueryInput(pair));
            this.queryWriter.write(CRLF);
            this.queryWriter.flush();
        }
        writer = this.panelWriter;
        synchronized (writer) {
            this.panelWriter.write(this.csvPanelDetail(pair));
            this.panelWriter.write(CRLF);
            this.panelWriter.flush();
        }
        writer = this.nodeWriter;
        synchronized (writer) {
            for (ReqResPair.NodeResponse singleNode : pair.getNodes()) {
                this.nodeWriter.write(this.csvResponse(singleNode));
                this.nodeWriter.write(CRLF);
                this.nodeWriter.flush();
            }
        }
    }

    public synchronized void close() throws IOException {
        this.queryWriter.close();
        this.panelWriter.close();
        this.nodeWriter.close();
    }

    public synchronized void warn(String message) throws IOException {
        System.out.println("WARN: " + message);
        this.warningWriter.write(message + CRLF);
        this.warningWriter.flush();
    }

    public synchronized void error(String message, Exception e) throws IOException {
        System.out.println("ERROR: " + e.getMessage());
        this.errorWriter.write(message + ":" + e.getMessage());
        this.errorWriter.write(CRLF);
        this.errorWriter.flush();
    }

    private void headers() throws IOException {
        this.queryWriter.write("-- queryMasterID, status, panels, items");
        this.queryWriter.write(CRLF);
        this.queryWriter.flush();
        this.nodeWriter.write("-- queryMasterID, nodeID, setSize, startTime, endTime");
        this.nodeWriter.write(CRLF);
        this.nodeWriter.flush();
    }

    private String csvQueryInput(ReqResPair pair) {
        StringBuilder csv = new StringBuilder();
        csv.append(pair.getQueryMasterID()).append(CSV).append(pair.getStatus().name()).append(CSV).append(pair.getPanels()).append(CSV).append(pair.getItems());
        return csv.toString();
    }

    private String csvPanelDetail(ReqResPair pair) throws IOException {
        StringBuilder csv = new StringBuilder();
        try {
            QueryDefinitionType queryDef = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)pair.getRequest()).getQueryDefinition();
            for (PanelType panel : queryDef.getPanel()) {
                for (ItemType item : panel.getItem()) {
                    csv.append(pair.getQueryMasterID()).append(CSV).append(panel.getPanelNumber()).append(CSV).append(this.replaceBackslashes(item.getItemKey()));
                }
            }
        }
        catch (Exception e) {
            this.error("Could not read query definition?", e);
        }
        return csv.toString();
    }

    String replaceBackslashes(String concept_path) {
        String ESCAPE_WINDOWS = "\\\\";
        String ESCAPE_UNIX = "/";
        return concept_path.replaceAll("\\\\", "/");
    }

    private String csvResponse(ReqResPair.NodeResponse node) {
        StringBuilder csv = new StringBuilder();
        csv.append(node.queryMasterID).append(CSV).append(node.nodeID).append(CSV).append(node.setSize).append(CSV).append(node.startTime).append(CSV).append(node.endTime);
        return csv.toString();
    }

    private void xml(ReqResPair pair) throws SerializationException {
        File requestFile = new File(this.batch + File.separator + "xml" + File.separator + pair.getQueryMasterID() + "_req.xml");
        File responseFile = new File(this.batch + File.separator + "xml" + File.separator + pair.getQueryMasterID() + "_res.xml");
        requestFile.getParentFile().mkdir();
        try {
            String requestXML = CRCSerializer.toXMLString((RequestMessageType)pair.getRequest());
            String responseXML = CRCSerializer.toXMLString((ResponseMessageType)pair.getResponse());
            FileUtils.write((File)requestFile, (String)requestXML);
            FileUtils.write((File)responseFile, (String)responseXML);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private Writer getWriter(String filename) throws IOException {
        File path = new File(this.batch + File.separator + filename);
        return this.getWriter(path);
    }

    private Writer getWriter(File file) throws IOException {
        System.out.println("Buffering to : " + file.getAbsolutePath());
        return new BufferedWriter(new FileWriter(file));
    }

    public File getBatchOutputDir() {
        return this.batch;
    }
}

