/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import java.io.IOException;
import java.util.concurrent.Callable;
import net.shrine.monitor.scanner.OutputWriter;
import net.shrine.monitor.scanner.ReqResPair;
import net.shrine.serializers.crc.CRCHttpClient;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;

public class ReqThread
implements Callable<ReqResPair> {
    private String url;
    private boolean anonymize;
    private ReqResPair pair;
    private OutputWriter writer;

    public ReqThread(String crcURL, RequestMessageType request) throws IOException {
        this.url = crcURL;
        this.writer = OutputWriter.getInstance();
        try {
            this.pair = new ReqResPair();
            this.pair.setRequest(request);
        }
        catch (Exception e) {
            this.writer.error("INVALID_REQUEST:RequestExecutor:", e);
        }
    }

    public ReqThread(String crcURL, RequestMessageType request, boolean anonymize) throws IOException {
        this(crcURL, request);
        this.anonymize = anonymize;
    }

    @Override
    public ReqResPair call() throws IOException {
        try {
            this.pair.setResponse(CRCHttpClient.sendRequestToCRC((String)this.url, (RequestMessageType)this.pair.getRequest()));
            if (this.pair.getStatus() != CRCQueryStatus.COMPLETED) {
                this.writer.warn(this.pair.getStatus().name() + "query " + this.pair.getQueryMasterID() + " failed at the MASTER LEVEL ");
            }
            for (QueryResultInstanceType result : CRCSerializer.getQueryResults((ResponseMessageType)this.pair.getResponse())) {
                if (this.anonymize) {
                    result.setSetSize(0);
                }
                if (!result.getQueryStatusType().getName().equals("COMPLETED")) continue;
                this.writer.warn(this.pair.getStatus().name() + "query " + this.pair.getQueryMasterID() + " failed at the NODE level for " + result.getDescription());
            }
        }
        catch (Exception e) {
            this.writer.error("INVALID_RESPONSE:CRCHttpClient.sendRequestToCRC(...):", e);
        }
        try {
            this.writer.write(this.pair);
        }
        catch (SerializationException e) {
            this.writer.error("INVALID_RESPONSE:writer.write(...):", (Exception)((Object)e));
        }
        return this.pair;
    }
}

