/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.PasswordType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.shrine.monitor.scanner.AdapterMappingsIterator;
import net.shrine.monitor.scanner.FlatFileIterator;
import net.shrine.monitor.scanner.QueryDefIterator;
import org.apache.log4j.Logger;
import org.spin.tools.StringTools;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

public class RuntimeArgs {
    public static final Logger log = Logger.getLogger(RuntimeArgs.class);
    public Source source;
    public String file;
    public String crc = "http://services.i2b2.org/i2b2/rest/QueryToolService/";
    public String domain = "HarvardDemo";
    public String project = "Demo";
    public String username = "demo";
    public String password = "demouser";
    public int queryTopicID = 0;
    public int threads = 1;
    public int sleep = 1000;
    public boolean translate = false;
    public boolean random = false;
    public boolean repeat = false;
    public boolean anonymize = false;
    Properties props;

    public RuntimeArgs(String file) throws IOException {
        this(new File(file));
    }

    public RuntimeArgs(File file) throws IOException {
        this(ConfigTool.getProperties((File)file));
    }

    public RuntimeArgs(Properties properties) {
        this.props = properties;
        this.source = this.getSource(this.getProperty("source"));
        if (this.notNullKey("crc")) {
            this.crc = this.getProperty("crc");
        }
        if (this.notNullKey("domain")) {
            this.domain = this.getProperty("domain");
        }
        if (this.notNullKey("project")) {
            this.project = this.getProperty("project");
        }
        if (this.notNullKey("username")) {
            this.username = this.getProperty("username");
        }
        if (this.notNullKey("password")) {
            this.password = this.getProperty("password");
        }
        if (this.notNullKey("queryTopicID")) {
            this.queryTopicID = this.parseInt("queryTopicID");
        }
        if (this.notNullKey("threads")) {
            this.threads = this.parseInt("threads");
        }
        if (this.notNullKey("file")) {
            this.file = this.getProperty("file");
        }
        if (this.notNullKey("random")) {
            this.random = this.parseBool("random");
        }
        if (this.notNullKey("translate")) {
            this.translate = this.parseBool("translate");
        }
        if (this.notNullKey("repeat")) {
            this.repeat = this.parseBool("repeat");
        }
        if (this.notNullKey("sleep")) {
            this.sleep = this.parseInt("sleep");
        }
        if (this.notNullKey("anonymize")) {
            this.anonymize = this.parseBool("anonymize");
        }
    }

    public boolean notNullKey(String key) {
        return this.props.containsKey(key) && this.props.getProperty(key).length() > 0;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public boolean parseBool(String key) {
        String value = this.getProperty(key);
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    private Integer parseInt(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(this.getProperty(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    public QueryDefIterator queryDefIterator() throws ConfigException, IOException {
        return RuntimeArgs.queryDefIterator(this.source, this.translate, this.file);
    }

    public static QueryDefIterator queryDefIterator(Source source, boolean translate, String argument) throws ConfigException, IOException {
        switch (source) {
            case AdapterMappings: {
                return new AdapterMappingsIterator(argument, translate);
            }
            case FlatFile: {
                return new FlatFileIterator(new File(argument));
            }
        }
        throw new ConfigException("No Impl for source type " + source.name());
    }

    public Source getSource(String source) {
        try {
            return Source.valueOf(source);
        }
        catch (Exception exception) {
            log.error((Object)("Invalid source " + source));
            return null;
        }
    }

    public SecurityType getSecurityType() {
        SecurityType security = new SecurityType();
        security.setDomain(this.domain);
        security.setUsername(this.username);
        PasswordType pwd = new PasswordType();
        pwd.setIsToken(Boolean.valueOf(false));
        pwd.setValue(this.password);
        security.setPassword(pwd);
        return security;
    }

    public static String[] supported() {
        return new String[]{"source", "file", "crc", "domain", "project", "username", "password", "queryTopicID", "translate", "random", "threads", "sleep"};
    }

    public String toString() {
        StringBuilder append = new StringBuilder();
        for (String key : RuntimeArgs.supported()) {
            append.append(key).append("=").append(this.getProperty(key));
            append.append(StringTools.crlf());
        }
        return append.toString();
    }

    public static enum Source {
        AdapterMappings,
        FlatFile,
        SavedQueries,
        OntologyCell;

    }
}

