/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.shrine.monitor.scanner.ShortHandNotation;
import org.spin.tools.FileUtils;
import org.spin.tools.StringTools;

public class ShortHandNotationIO {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd#hh.mm.ssa");
    private static final String CRLF = StringTools.crlf();

    public static void write(File outputFile, List<QueryDefinitionType> queries) throws IOException {
        System.out.println("Writing to " + outputFile.getAbsolutePath());
        FileUtils.write((File)outputFile, (String)ShortHandNotationIO.read(queries));
    }

    public static void write(File outputFile, QueryDefinitionType ... queries) throws IOException {
        ShortHandNotationIO.write(outputFile, Arrays.asList(queries));
    }

    public static String read(QueryDefinitionType ... queries) {
        return ShortHandNotationIO.read(Arrays.asList(queries));
    }

    public static String read(List<QueryDefinitionType> queries) {
        StringBuilder dsl = new StringBuilder();
        String user = System.getProperty("user.name");
        String stamp = format.format(new Date());
        dsl.append("# Generated by " + CRLF);
        dsl.append("# user " + user + CRLF);
        dsl.append("# time " + stamp + CRLF);
        for (QueryDefinitionType query : queries) {
            dsl.append(ShortHandNotation.def.print());
            dsl.append(CRLF);
            if (query.getQueryName() != null && query.getQueryName().length() > 0) {
                dsl.append(ShortHandNotation.panel.print());
                dsl.append(CRLF);
                dsl.append(query.getQueryName());
                dsl.append(CRLF);
            }
            for (PanelType panel : query.getPanel()) {
                dsl.append(ShortHandNotation.panel.print());
                dsl.append(CRLF);
                for (ItemType item : panel.getItem()) {
                    dsl.append(item.getItemKey());
                    dsl.append(CRLF);
                }
            }
            dsl.append(CRLF);
        }
        dsl.append(CRLF);
        dsl.append(ShortHandNotation.end.print());
        dsl.append(CRLF);
        return dsl.toString();
    }
}

