/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import java.util.HashMap;
import net.shrine.config.CellNames;
import org.apache.log4j.Logger;

public class I2B2HiveConfig {
    public static final Logger log = Logger.getLogger(I2B2HiveConfig.class);
    protected HashMap<String, String> cells = new HashMap();

    public void addCell(CellNames cellName, String cellUrl) {
        this.addCell(cellName.name(), cellUrl);
    }

    public void addCell(String cellName, String cellUrl) {
        this.cells.put(cellName, cellUrl);
    }

    public void removeCell(CellNames cellName, String cellUrl) {
        this.cells.remove(cellName.name());
    }

    public void removeCell(String cellName) {
        this.cells.remove(cellName);
    }

    public String getSheriffURL() {
        return this.getUrl(CellNames.SHERIFF);
    }

    public String getPMURL() {
        return this.getUrl(CellNames.PM);
    }

    public String getONTURL() {
        return this.getUrl(CellNames.ONT);
    }

    public String getCRCURL() {
        return this.getUrl(CellNames.CRC);
    }

    public String getAggregatorURL() {
        return this.getUrl(CellNames.AGGREGATOR);
    }

    public String getUrl(CellNames cellName) {
        return this.getUrl(cellName.name());
    }

    public String getUrl(String cellName) {
        if (!this.hasCell(cellName)) {
            log.warn((Object)("Attempting to get URL for a cell that does not exist. Expected behavior? cell name = " + cellName));
            return null;
        }
        return this.cells.get(cellName);
    }

    public boolean hasSheriff() {
        return this.hasCell(CellNames.SHERIFF);
    }

    public boolean hasONT() {
        return this.hasCell(CellNames.ONT);
    }

    public boolean hasCRC() {
        return this.hasCell(CellNames.CRC);
    }

    public boolean hasPM() {
        return this.hasCell(CellNames.PM);
    }

    public boolean hasAggregator() {
        return this.hasCell(CellNames.AGGREGATOR);
    }

    public boolean hasCell(CellNames cellName) {
        return this.hasCell(cellName.name());
    }

    public boolean hasCell(String cellName) {
        return this.cells.containsKey(cellName);
    }

    public HashMap<String, String> getCells() {
        return this.cells;
    }

    public void setCells(HashMap<String, String> cells) {
        this.cells = cells;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I2B2HiveConfig other = (I2B2HiveConfig)o;
        if (this.cells.keySet().size() != other.cells.keySet().size()) {
            return false;
        }
        for (String cellName : this.cells.keySet()) {
            if (!other.cells.containsKey(cellName)) {
                return false;
            }
            if (this.cells.get(cellName).equals(other.cells.get(cellName))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "I2B2HiveConfig{cells=" + this.cells + '}';
    }
}

