/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;

@XmlRootElement
@XmlType(propOrder={"queryMasterId", "queryInstanceId", "queryResultIds", "request"})
public final class ShrineHeader {
    @XmlElement(name="query_masterId", required=true)
    private final Long queryMasterId;
    @XmlElement(name="query_instanceId", required=true)
    private final Long queryInstanceId;
    @XmlElement(name="query_resultIds", required=true)
    private final List<Long> queryResultIds;
    @XmlElement(name="request_messageType", required=true)
    private final RequestMessageType request;

    public ShrineHeader() {
        this(null, null, Collections.emptyList(), null);
    }

    public ShrineHeader(Long queryMasterId, Long queryInstanceId, List<Long> queryResultIds, RequestMessageType request) {
        this.queryMasterId = queryMasterId;
        this.queryInstanceId = queryInstanceId;
        this.queryResultIds = Util.makeArrayList(queryResultIds);
        this.request = request;
    }

    public Long getQueryMasterId() {
        return this.queryMasterId;
    }

    public Long getQueryInstanceId() {
        return this.queryInstanceId;
    }

    public List<Long> getQueryResultIds() {
        return this.queryResultIds;
    }

    public RequestMessageType getRequest() {
        return this.request;
    }

    public ShrineHeader withQueryMasterId(Long queryMasterId) {
        return new ShrineHeader(queryMasterId, this.queryInstanceId, this.queryResultIds, this.request);
    }

    public ShrineHeader withQueryInstanceId(Long queryInstanceId) {
        return new ShrineHeader(this.queryMasterId, queryInstanceId, this.queryResultIds, this.request);
    }

    public ShrineHeader withQueryResultId(Long queryResultId) {
        List<Object> resultIDs = queryResultId == null ? Collections.emptyList() : Arrays.asList(queryResultId);
        return new ShrineHeader(this.queryMasterId, this.queryInstanceId, resultIDs, this.request);
    }

    public ShrineHeader withQueryResultIds(List<Long> queryResultIds) {
        return new ShrineHeader(this.queryMasterId, this.queryInstanceId, queryResultIds, this.request);
    }

    public ShrineHeader withRequest(RequestMessageType request) {
        return new ShrineHeader(this.queryMasterId, this.queryInstanceId, this.queryResultIds, request);
    }
}

