/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.pdo.query.PatientDataResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterInstanceResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import org.spin.tools.Util;

public enum CRCResponseType {
    MasterResponseType(MasterResponseType.class),
    InstanceResponseType(InstanceResponseType.class),
    ResultResponseType(ResultResponseType.class),
    MasterInstanceResultResponseType(MasterInstanceResultResponseType.class),
    PatientDataResponseType(PatientDataResponseType.class);

    public final Class<?> requestClass;

    private CRCResponseType(Class<?> requestClass) {
        this.requestClass = requestClass;
    }

    public static CRCResponseType fromClass(Class<?> desiredRequestClass) {
        Util.guardNotNull(desiredRequestClass);
        for (CRCResponseType type : CRCResponseType.values()) {
            if (type.requestClass != desiredRequestClass) continue;
            return type;
        }
        throw new IllegalArgumentException("No CRCResponseType for class '" + desiredRequestClass + "'");
    }

    public static CRCResponseType fromClass(String desiredRequestClassName) {
        Util.guardNotNull((Object)desiredRequestClassName);
        try {
            return CRCResponseType.fromClass(Class.forName(desiredRequestClassName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

