/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.identity;

import org.apache.log4j.Logger;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.crypto.signature.Identity;

public final class IdentityServiceFactory {
    private static final Logger log = Logger.getLogger(IdentityServiceFactory.class);
    private static final boolean INFO = log.isInfoEnabled();

    private IdentityServiceFactory() {
    }

    public static final IdentityService makeLazyIdentityService(final NodeConfig config) {
        Util.guardNotNull((Object)config);
        Util.guardNotNull((Object)config.isAuthenticator());
        return new IdentityService(){
            private volatile IdentityService delegate = null;
            private final boolean isAuthenticator = config.isAuthenticator();
            private final Object lock = new Object();

            @Override
            public Identity certify(String domain, String username, String password) throws IdentityServiceException {
                if (this.isAuthenticator) {
                    this.initDelegate();
                    return this.delegate.certify(domain, username, password);
                }
                if (INFO) {
                    log.info((Object)"certify() invoked on an IdentityService not configured as an authenticator; returning null.");
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void initDelegate() throws IdentityServiceException {
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate == null) {
                        Util.guardNotNull((Object)config.getIdentityServiceClass());
                        try {
                            this.delegate = (IdentityService)ClassTools.createInstance((String)config.getIdentityServiceClass(), IdentityService.class);
                        }
                        catch (DynamicLoadingException e) {
                            throw new IdentityServiceException(e);
                        }
                    }
                }
            }
        };
    }

    public static final IdentityService makeIdentityService(NodeConfig config) throws ConfigException {
        if (config == null) {
            throw new ConfigException("Null NodeConfig passed in");
        }
        if (config.getIdentityServiceClass() == null) {
            throw new ConfigException("Null identity service class name passed in");
        }
        try {
            return (IdentityService)ClassTools.createInstance((String)config.getIdentityServiceClass(), IdentityService.class);
        }
        catch (DynamicLoadingException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public static final IdentityService makeIdentityService() throws ConfigException {
        return IdentityServiceFactory.makeIdentityService(ConfigTool.loadNodeConfig());
    }
}

